package com.wecloud.im.controller;

import com.wecloud.im.param.ImHistoryMessagePageParam;
import com.wecloud.im.param.add.ImMsgRecall;
import com.wecloud.im.param.add.ImMsgUpdate;
import com.wecloud.im.service.ImMessageService;
import com.wecloud.im.vo.ImMessageOfflineListVo;
import com.wecloud.im.vo.OfflineMsgDto;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 消息存储表 控制器
 *
 * @author wei
 * @since 2021-04-29
 */
@Slf4j
@RestController
@RequestMapping("/imMessage")
@Api(value = "消息存储表API", tags = {"消息存储表"})
public class ImMessageController extends BaseController {

    @Autowired
    private ImMessageService imMessageService;

    /**
     * 消息撤回
     */
    @PostMapping("/withdraw")
    @ApiOperation(value = "消息撤回", notes = "只能撤回客户端自己发送的消息")
    public ApiResult<Boolean> updateMsgWithdrawById(@RequestBody ImMsgRecall imMsgRecall) throws Exception {
        return imMessageService.updateMsgWithdrawById(imMsgRecall);
    }

    /**
     * 修改消息体
     */
    @PostMapping("/updateMsgById")
    @ApiOperation(value = "修改消息体", notes = "只能修改客户端自己发送的消息")
    public ApiResult<Boolean> updateMsgById(@RequestBody ImMsgUpdate imMsgUpdate) throws Exception {
        return imMessageService.updateMsgById(imMsgUpdate);
    }

    /**
     * 离线消息列表
     */
    @PostMapping("/offlineList")
    @ApiOperation(value = "离线消息列表")
    public ApiResult<List<ImMessageOfflineListVo>> getOfflineList() throws Exception {
        List<ImMessageOfflineListVo> offlineList = imMessageService.getOfflineList();
        return ApiResult.ok(offlineList);
    }

    /**
     * 查询某个会话历史消息分页列表
     */
    @PostMapping("/getHistoryMsg")
    @OperationLog(name = "查询某个会话历史消息分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "查询某个会话历史消息分页列表")
    public ApiResult<Paging<OfflineMsgDto>> getHistoryMsg(@Validated @RequestBody ImHistoryMessagePageParam imHistoryMessagePageParam) throws Exception {
        Paging<OfflineMsgDto> paging = imMessageService.getHistoryMsgConversationId(imHistoryMessagePageParam);
        return ApiResult.ok(paging);
    }

//
//    /**
//     * 添加消息存储表
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加消息存储表", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加消息存储表")
//    public ApiResult<Boolean> addImMessage(@Validated(Add.class) @RequestBody ImMessage imMessage) throws Exception {
//        boolean flag = imMessageService.saveImMessage(imMessage);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 修改消息存储表
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改消息存储表", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改消息存储表")
//    public ApiResult<Boolean> updateImMessage(@Validated(Update.class) @RequestBody ImMessage imMessage) throws Exception {
//        boolean flag = imMessageService.updateImMessage(imMessage);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除消息存储表
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除消息存储表", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除消息存储表")
//    public ApiResult<Boolean> deleteImMessage(@PathVariable("id") Long id) throws Exception {
//        boolean flag = imMessageService.deleteImMessage(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取消息存储表详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "消息存储表详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "消息存储表详情")
//    public ApiResult<ImMessageQueryVo> getImMessage(@PathVariable("id") Long id) throws Exception {
//        ImMessageQueryVo imMessageQueryVo = imMessageService.getImMessageById(id);
//        return ApiResult.ok(imMessageQueryVo);
//    }
//
//    /**
//     * 消息存储表分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "消息存储表分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "消息存储表分页列表")
//    public ApiResult<Paging<ImMessageQueryVo>> getImMessagePageList(@Validated @RequestBody ImMessagePageParam imMessagePageParam) throws Exception {
//        Paging<ImMessageQueryVo> paging = imMessageService.getImMessagePageList(imMessagePageParam);
//        return ApiResult.ok(paging);
//    }

}

