package com.wecloud.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.mapper.ImApplicationMapper;
import com.wecloud.im.param.ImApplicationPageParam;
import com.wecloud.im.param.ImApplicationQueryVo;
import com.wecloud.im.service.ImApplicationService;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 第三方应用表 服务实现类
 *
 * @author wei
 * @since 2021-04-27
 */
@Slf4j
@Service
@CacheConfig(cacheNames = "applic")
public class ImApplicationServiceImpl extends BaseServiceImpl<ImApplicationMapper, ImApplication> implements ImApplicationService {

    @Autowired
    private ImApplicationMapper imApplicationMapper;

    @Override
    @Cacheable(key = "#p0")
    public ImApplication getCacheAppByAppKey(String appKey) {
        ImApplication imApplication = this.getOne(
                new QueryWrapper<ImApplication>().lambda()
                        .eq(ImApplication::getAppKey, appKey)
        );
        return imApplication;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveImApplication(ImApplication imApplication) throws Exception {
        return super.save(imApplication);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateImApplication(ImApplication imApplication) throws Exception {
        return super.updateById(imApplication);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteImApplication(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public ImApplicationQueryVo getImApplicationById(Long id) throws Exception {
        return imApplicationMapper.getImApplicationById(id);
    }

    @Override
    public Paging<ImApplicationQueryVo> getImApplicationPageList(ImApplicationPageParam imApplicationPageParam) throws Exception {
        Page<ImApplicationQueryVo> page = new PageInfo<>(imApplicationPageParam, OrderItem.desc(getLambdaColumn(ImApplication::getCreateTime)));
        IPage<ImApplicationQueryVo> iPage = imApplicationMapper.getImApplicationPageList(page, imApplicationPageParam);
        return new Paging<ImApplicationQueryVo>(iPage);
    }

}
