package com.wecloud.im.sdk.model;

import lombok.Data;

/**
 *
 * @Author luozh
 * @Date 2022年05月05日 09:55
 * @Version 1.0
 */
@Data
public class PushExtParam {

    /**
     * 通知栏显示主题
     */
    private String title;

    /**
     * 按厂商设置不同推送属性。支持的推送通道值为 `MI`（小米）、`HW`（华为）、`OPPO`、`VIVO`
     */
    private String pushChannel;

    /**
     * 通知渠道的 ID
     */
    private String channelId;

    /**
     * 华为通知栏消息优先级，取值 NORMAL、LOW，默认为 NORMAL 重要消息
     */

    private String hwPriority;

    /**
     * 华为推送自定义的通知栏消息右侧大图标 URL，如果不设置，则不展示通知栏右侧图标
     */
    private String hwImage;

    /**
     * 小米推送自定义的通知栏消息右侧图标 URL
     */
    private String miLargeIconUri;

    /**
     * vivo 推送通道类型。0 为运营消息、1 为系统消息
     */
    private String vivoChannelType;

    /**
     *  iOS 平台通知栏分组 ID
     */
    private String iosGroupId;

    /**
     * iOS 平台
     */
    private String iosApnsCollapseId;
}
