
package com.wecloud.dispatch;

import com.wecloud.dispatch.annotation.ActionMapping;
import com.wecloud.dispatch.config.ActionConfigurer;
import com.wecloud.dispatch.extend.ActionBox;
import com.wecloud.dispatch.extend.impl.DefaultActionBox;
import com.wecloud.dispatch.registry.ActionBoxRegistry;
import com.wecloud.dispatch.registry.ActionInterceptorRegistry;
import com.wecloud.dispatch.registry.ActionMethodInterceptorRegistry;
import com.wecloud.dispatch.registry.ActionRegistry;
import com.wecloud.dispatch.registry.ArgumentDefaultValueBuilderRegistry;
import com.wecloud.dispatch.registry.MethodArgumentResolverRegistry;
import com.wecloud.dispatch.util.ClassScaner;
import lombok.extern.slf4j.Slf4j;

import java.util.Set;

/**
 * @author lixiaozhong
 */
@Slf4j
public class ActionContext {

	private final ActionRegistry actionRegistry = new ActionRegistry();
	private final ActionBoxRegistry actionBoxRegistry = new ActionBoxRegistry();
	private final ActionMethodInterceptorRegistry actionMethodInterceptorRegistry = new ActionMethodInterceptorRegistry();
	private final MethodArgumentResolverRegistry methodArgumentResolverRegistry = new MethodArgumentResolverRegistry();
	private final ActionInterceptorRegistry actionInterceptorRegistry = new ActionInterceptorRegistry();
	private final ActionBox actionBox = new DefaultActionBox();
	private final ArgumentDefaultValueBuilderRegistry argumentDefaultValueBuilderRegistry = new ArgumentDefaultValueBuilderRegistry();
	private final ActionDispatcher actionDispatcher;

	public ActionContext(ActionDispatcher actionDispatcher) {
		super();
		this.actionDispatcher = actionDispatcher;
	}

	@SuppressWarnings("unchecked")
	public void scan(String... path) {
		// 扫描包下面的所有被注解ActionMapping的类
		Set<Class<?>> classSet = ClassScaner.scan(path, ActionMapping.class);
		for (Class<?> classType : classSet) {
			log.info("ActionMapping scan, find: {}", classType.getTypeName());
			actionRegistry.add(classType);
		}
	}

	@SuppressWarnings("unchecked")
	public void cover(String... path) {
		// 扫描xxx包下面的所有被注解ActionMapping的类
		Set<Class<?>> classSet = ClassScaner.scan(path, ActionMapping.class);
		for (Class<?> classType : classSet) {
			actionRegistry.cover(classType);
		}
	}

	public void cover(Class<?> classType) {
		actionRegistry.cover(classType);
	}

	public void addConfig(ActionConfigurer actionConfigurer) {
		actionConfigurer.addConfig(this);
	}

	public ActionRegistry getActionRegistry() {
		return actionRegistry;
	}

	public ActionBoxRegistry getActionBoxRegistry() {
		return actionBoxRegistry;
	}

	public MethodArgumentResolverRegistry getMethodArgumentResolverRegistry() {
		return methodArgumentResolverRegistry;
	}

	public ActionInterceptorRegistry getActionInterceptorRegistry() {
		return actionInterceptorRegistry;
	}

	public ActionBox getActionBox() {
		return actionBox;
	}

	public ActionMethodInterceptorRegistry getActionMethodInterceptorRegistry() {
		return actionMethodInterceptorRegistry;
	}

	public ArgumentDefaultValueBuilderRegistry getArgumentDefaultValueBuilderRegistry() {
		return argumentDefaultValueBuilderRegistry;
	}

	public ActionDispatcher getActionDispatcher() {
		return actionDispatcher;
	}
}
