package com.sien.common.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 状态，0-正常，1-完成，99-删除
 */
@Getter
@AllArgsConstructor
public enum StrokeDiscountStatusEnum implements BaseEnum {

    OK(0, "正常"),
    COMPLETE(1, "完成"),
    CANCEL(99, "取消");

    /**
     * 编号
     */
    private final Integer code;
    /**
     * 名称
     */
    private final String desc;


}
