package com.jumeirah.common.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 航空公司商家表
 *
 * @author giao
 * @since 2020-10-16
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "Merchant对象")
public class Merchant extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {Update.class})
    @ApiModelProperty("主键")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty("商家名称")
    private String name;

    @ApiModelProperty("联系人手机号码")
    private String phone;

    @ApiModelProperty("联系人手机区号")
    private String phoneArea;

    @ApiModelProperty("公司头像")
    private String head;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("状态，0：禁用，1：启用，2：锁定")
    private Integer state;

    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    @TableLogic
    private Integer deleted;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("商家开户银行")
    private String rechargeBank;

    @ApiModelProperty("商家开户名称")
    private String rechargeName;

    @ApiModelProperty("商家银行卡号")
    private String rechargeBankNumber;

    @ApiModelProperty("在列表展示的图片url")
    private String imageListUrl;

    @NotNull(message = "在列表展示的图片高度不能为空")
    @ApiModelProperty("在列表展示的图片高度")
    private Long imageListHeight;

    @NotNull(message = "在列表展示的图片宽度不能为空")
    @ApiModelProperty("在列表展示的图片宽度")
    private Long imageListWidth;

    @ApiModelProperty("公司介绍图片url")
    private String imageCompanyIntroductionUrl;

    @ApiModelProperty("团队介绍图片url")
    private String imageTeamIntroductionUrl;

    @ApiModelProperty("优势图片url")
    private String imageAdvantageUrl;

    @ApiModelProperty("公司介绍文字")
    private String textCompanyIntroduction;

    @ApiModelProperty("团队介绍文字")
    private String textTeamIntroduction;

    @ApiModelProperty("优势介绍文字")
    private String textAdvantage;

    @ApiModelProperty("航空公司名称")
    private String airlineName;

    @ApiModelProperty("公司所在地址")
    private String location;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("营业执照图片url")
    private String imageBusinessLicenseUrl;

    @ApiModelProperty("审核注册状态 0未审核,1审核成功")
    private Integer auditRegisterStatus;

}
