package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.jumeirah.common.entity.StrokeDiscount;
import com.jumeirah.common.param.StrokeDiscountPageParam;
import com.jumeirah.common.vo.StrokeDiscountQueryVo;

import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;

/**
 * 优惠行程表 Mapper 接口
 *
 * @author xxx
 * @since 2020-10-14
 */
@Repository
public interface StrokeDiscountMapper extends BaseMapper<StrokeDiscount> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    StrokeDiscountQueryVo getStrokeDiscountById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param strokeDiscountPageParam
     * @return
     */
    IPage<StrokeDiscountQueryVo> getStrokeDiscountPageList(@Param("page") Page page, @Param("param") StrokeDiscountPageParam strokeDiscountPageParam);

}
