# wecloud-RTC音视频客户端信令对接文档

## 文档描述

此文档为单人RTC音视频通讯技术对接文档

由于RTC基于wecloud-im即时通讯服务,**对接RTC前,需要先对接wecloud-im服务**

## 核心概念说明

### 频道与会话

频道与会话的概念不一样

```
1. 引入"频道RtcChannel"概念, 可以不基于会话发起音视频通话
2. 目前频道只支持两个client,进行通话的两端必须先加入到同一个"频道",所有的指令都在频道内进行转发
3. 允许不在同个会话中的两个client加入到同个频道进行通话 (可配置是否两个client必须在同一个会话才能发起音视频通话)
4. 一个频道可以由通话发起者绑定到会话ID,"挂断","未接听"等状态会同步到会话, 未绑定将不同步到会话(可选)
5. 连接websocket时带上client类型, 如web,安卓,ios
client需要监听频道内 状态更新(房间断开,挂断)、用户状态更新(用户加入, 用户退出)、流状态更新(切换音频 切换视频)
6.如果接收方未在线时收到音视频通话邀请,在规定时间内发起方还在等待中,发起方重新连接可以收到音视频通话的离线信令
```

## 流程图

### 不绑定到会话 示例一

![image-20211018180059906](https://tva1.sinaimg.cn/large/008i3skNly1gvjmbmw0wcj60u016877z02.jpg)



## subCmd指令码说明

枚举类:

```

/**
* 接收到RTC邀请
*/
RTC_CALL(1),

/**
* 用户状态更新事件(用户加入频道)
*/
CLIENT_JOIN(2),

/**
* 用户状态更新事件(用户退出频道)
*/
CLIENT_LEAVE(3),

/**
* 用户状态更新事件(用户拒接邀请,不同意进入频道)
*/
CLIENT_REJECT(4),

/**
* SDP数据转发
*/
SDP_FORWARD(5),

/**
* candidate候选者数据转发
*/
CANDIDATE_FORWARD(6);

```

## 创建频道 发起RTC音视频通话 (http)

见http接口文档



## 接收方收到RTC音视频通话邀请(ws)

服务端向client接收方下发数据:

```json
{
"cmd":4,
"data":{
  "subCmd":"1",
  "subData":{
    "type":"video",
    "conversationId":null,
    "channelId":1234263457652,
    "timestamp":113123123,
    "clientId":"client_1010"
  },
  "attrs":{
    "a":"示例: 用户自定义的一些键值对",
    "b":"存储用户自定义的一些键值对"
  }
	}
}
```

**参数描述**

| 字段名  | 字段类型 | 是否可空 | 说明 |
| ---- | -------- | -- | ------ |
| cmd            | String   | 否       | 指令码                 |
| attrs          | Object   | 是       | 自定义拓展字段		 |
| conversationId | Long     | 否       | 绑定的会话id              |
| subCmd | String     | 否       | 子类型指令            |
| clientId | String     | 否       | 发起通话的客户端ID              |
| channelId | Long     | 否       | 由服务端创建的频道id   |
| type | String | 否       | 类型: "video" 或 "voice" |
| timestamp | Timestamp | 否       | 频道创建时间戳 |

## 同意加入频道(http)

见http接口文档



## 有client加入频道(ws下发)

服务端向频道内其他client响应数据:
```json
{
"cmd":4,
"data":{
  "subCmd":"2",
  "subData":{
    "channelId":1234263457652,
    "clientId":7657567,
  }
	}
}
```

## 拒绝加入频道 http

见http接口文档


## 有Client拒绝加入频道(ws下发)

服务端向频道内其他client响应数据:

```json
{
"cmd":4,
"data":{
  "subCmd":4,
  "subData":{
    "channelId":1234263457652,
    "clientId":7657567,
  }
	}
}
```

## SDP转发

 流媒体描述信息

（服务端仅负责转发）（candidate,anser,offer）

### client上传SDP  (http接口)

见http接口文档

### client接收SDP (ws下发)

```json
{
"cmd":4,
"data":{
  "subCmd":5,
  "subData":{
    "channelId":1234263457652,
    "clientId":7657567,
    "sdpData":"xxxxxxxxxxxxxxxx",
    "sdpType":"Offer/Answer"
  },
    "attrs":{}
	}
}
```

**参数描述**

| 字段名  | 字段类型 | 是否可空 | 说明 |
| ---- | -------- | -- | ------ |
| cmd            | String   | 否       | 指令码                 |
| attrs          | Object   | 是       | 自定义拓展字段		 |
| channelId | Long     | 否       | 频道id               |
| diyParam自定义字段 | Object     | 是       | 自定义拓展字段        |
| subCmd | String     | 否       | 子指令            |
| sdpData | String     | 否       | sdp转发的数据    |
| sdpType | String     | 否       | sdp类型: Offer或Answer |



## Candidate转发

候选人信息

（服务端仅负责转发）（candidate,anser,offer）

### client上传Candidate  (http接口)

见http接口文档

### client接收Candidate (ws下发)

```json
{
"cmd":4,
"data":{
  "subCmd":6,
  "subData":{
    "channelId":1234263457652,
    "clientId":7657567,
    "candidateData":"xxxxxxxxxxxxxxxx",
  },
    "attrs":{}
	}
}
```

**参数描述**

| 字段名  | 字段类型 | 是否可空 | 说明 |
| ---- | -------- | -- | ------ |
| cmd            | String   | 否       | 指令码                 |
| attrs          | Object   | 是       | 自定义拓展字段		 |
| channelId | Long     | 否       | 频道id               |
| diyParam自定义字段 | Object     | 是       | 自定义拓展字段        |
| subCmd | String     | 否       | 子指令            |
| candidateData | String     | 否       | 转发的候选者数据    |





## 主动挂断(离开频道) http



见http接口文档

## 有client离开频道(ws下发)

服务端向频道内其他client响应数据:

```json
{
"cmd":4,
"data":{
  "subCmd":3,
  "subData":{
    "channelId":1234263457652,
    "clientId":7657567
  }
	}
}
```

##  查询忙线状态(对方正在通话中) http

见http接口文档


## 断线重连

重新join进频道即可重连

## 对方是否还挂起

## 查询频道信息及在线人员 http

## 视频/音频切换

## 查询对方是否离开频道



