package com.wecloud.im.mapper;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImConversation;
import com.wecloud.im.param.ImConversationPageParam;
import com.wecloud.im.param.ImConversationQueryVo;
import com.wecloud.im.vo.ConversationVo;

/**
 * 会话表 Mapper 接口
 *
 * @author wei
 * @since 2021-05-07
 */
@Repository
public interface ImConversationMapper extends BaseMapper<ImConversation> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    ImConversationQueryVo getImConversationById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param imConversationPageParam
     * @return
     */
    IPage<ImConversationQueryVo> getImConversationPageList(@Param("page") Page page, @Param("param") ImConversationPageParam imConversationPageParam);


    /**
     * 查询用户加入的所有会话 与每个会话的未读条数 成员
     *
     * @param currentClientId
     * @return
     */
    List<ConversationVo> getMyImConversationListAndMsgCount(@Param("currentClientId") Long currentClientId, @Param("conversationId") Long conversationId);

    /**
     * 查询用户加入的所有会话
     *
     * @param clientId
     * @return
     */
    List<ImConversation> getMyImConversationList(@Param("clientId") Long clientId);

    /**
     * 查询已经存在的一对一会话信息
     *
     * @param clientId1
     * @param clientId2
     * @param isEncrypt 是否加密会话 1-是 0-否
     * @return
     */
    ImConversation getRepetitionConversationSingle(@Param("clientId1") Long clientId1, @Param("clientId2") Long clientId2, @Param("isEncrypt") Integer isEncrypt);

    /**
     * 判断重复会话中的Attributes是否一样
     *
     * @param clientId1
     * @param clientId2
     * @param attributes
     * @return 大于等于1为有重复会话
     */
    Long getRepetitionConversationAttributes(@Param("clientId1") Long clientId1, @Param("clientId2") Long clientId2, @Param("attributes") String attributes);

    /**
     * 增减成员数量
     * @param appId fkAppid
     * @param conversationId 会话id
     * @param addCount 要增减的人数， 负数是减
     * @return
     */
    boolean addMemberCount(@Param("appId") Long appId, @Param("conversationId") Long conversationId, @Param("addCount") int addCount);

    /**
     * 升级成万人群
     * @param appId fkAppId
     * @param conversationId 会话id
     * @return 成功则返回true
     */
    boolean upgradeToThousandChat(@Param("appId") Long appId, @Param("conversationId") Long conversationId);

    /**
     * 获取发件人和收件人会话列表
     * @Author luozh
     * @Date 2022年05月06日 07:15:05
     * @param senderClientId 发件人im client id
     * @param receiverClientIds 收件人 im client ids
     * @Return
     */
    List<ImConversation> getConversationBySenderAndReceivers(@Param("senderImClientId") Long senderImClientId, @Param(
            "receiverImClientIds") Collection<Long> receiverImClientIds);
}
