package com.wecloud.im.thousandchat.param;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author lixiaozhong
 * 最后一条已接收消息
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImMsgReceivedStatusUpdate")
public class LastestReceivedMsg extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "消息id，只需要发送最新的一条已接收消息", required = true)
    @NotNull(message = "消息ID不能为空")
    private Long lastestMsgId;

    @ApiModelProperty(value = "是否同时修改为已读状态", required = false)
    private Boolean readStatus = false;
}
