/*
 * Decompiled with CFR 0.152.
 */
package com.wecloud.classencrypt.util;

import com.wecloud.classencrypt.util.IoUtils;
import com.wecloud.classencrypt.util.StrUtils;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class EncryptUtils {
    public static final char[] SALT = new char[]{'w', 'h', 'o', 'i', 's', 'y', 'o', 'u', 'r', 'd', 'a', 'd', 'd', 'y', '#', '$', '@', '#', '@'};
    private static int KEY_LENGTH = 1024;

    public static byte[] en(byte[] msg, char[] key, int type) {
        if (type == 1) {
            return EncryptUtils.enAES(msg, EncryptUtils.md5(StrUtils.merger(key, SALT), true));
        }
        return EncryptUtils.enSimple(msg, key);
    }

    public static byte[] de(byte[] msg, char[] key, int type) {
        if (type == 1) {
            return EncryptUtils.deAES(msg, EncryptUtils.md5(StrUtils.merger(key, SALT), true));
        }
        return EncryptUtils.deSimple(msg, key);
    }

    public static byte[] md5byte(char[] str) {
        byte[] b = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = StrUtils.toBytes(str);
            md.update(buffer);
            b = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return b;
    }

    public static char[] md5(char[] str) {
        return EncryptUtils.md5(str, false);
    }

    public static char[] md5(char[] str, boolean sh0rt) {
        byte[] s = EncryptUtils.md5byte(str);
        if (s == null) {
            return null;
        }
        int begin = 0;
        int end = s.length;
        if (sh0rt) {
            begin = 8;
            end = 16;
        }
        char[] result = new char[]{};
        for (int i = begin; i < end; ++i) {
            result = StrUtils.merger(result, Integer.toHexString(0xFF & s[i] | 0xFFFFFF00).substring(6).toCharArray());
        }
        return result;
    }

    public static byte[] enSimple(byte[] msg, int start, int end, char[] key) {
        byte[] keys = IoUtils.merger(EncryptUtils.md5byte(StrUtils.merger(key, SALT)), EncryptUtils.md5byte(StrUtils.merger(SALT, key)));
        for (int i = start; i <= end; ++i) {
            msg[i] = (byte)(msg[i] ^ keys[i % keys.length]);
        }
        return msg;
    }

    public static byte[] deSimple(byte[] msg, int start, int end, char[] key) {
        byte[] keys = IoUtils.merger(EncryptUtils.md5byte(StrUtils.merger(key, SALT)), EncryptUtils.md5byte(StrUtils.merger(SALT, key)));
        for (int i = start; i <= end; ++i) {
            msg[i] = (byte)(msg[i] ^ keys[i % keys.length]);
        }
        return msg;
    }

    public static byte[] enSimple(byte[] msg, char[] key) {
        return EncryptUtils.enSimple(msg, 0, msg.length - 1, key);
    }

    public static byte[] deSimple(byte[] msg, char[] key) {
        return EncryptUtils.deSimple(msg, 0, msg.length - 1, key);
    }

    public static String enRSA(String str, String publicKey) {
        try {
            byte[] in = str.getBytes("UTF-8");
            byte[] out = EncryptUtils.enRSA(in, publicKey);
            String outStr = Base64.getEncoder().encodeToString(out);
            return outStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] enRSA(byte[] msg, String publicKey) {
        try {
            byte[] decoded = Base64.getDecoder().decode(publicKey.getBytes("UTF-8"));
            RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, pubKey);
            return EncryptUtils.cipherDoFinal(cipher, msg, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String deRSA(String str, String privateKey) {
        try {
            byte[] inputByte = Base64.getDecoder().decode(str.getBytes("UTF-8"));
            String outStr = new String(EncryptUtils.deRSA(inputByte, privateKey));
            return outStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] deRSA(byte[] msg, String privateKey) {
        try {
            byte[] decoded = Base64.getDecoder().decode(privateKey.getBytes("UTF-8"));
            RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, priKey);
            return EncryptUtils.cipherDoFinal(cipher, msg, 2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] cipherDoFinal(Cipher cipher, byte[] msg, int mode) throws Exception {
        int in_length = 0;
        if (mode == 1) {
            in_length = KEY_LENGTH / 8 - 11;
        } else if (mode == 2) {
            in_length = KEY_LENGTH / 8;
        }
        byte[] in = new byte[in_length];
        byte[] out = new byte[]{};
        for (int i = 0; i < msg.length; ++i) {
            if (msg.length - i < in_length && i % in_length == 0) {
                in = new byte[msg.length - i];
            }
            in[i % in_length] = msg[i];
            if (i != msg.length - 1 && i % in_length + 1 != in_length) continue;
            out = IoUtils.merger(out, cipher.doFinal(in));
        }
        return out;
    }

    public static Map<Integer, String> genKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(KEY_LENGTH, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        BigInteger publicExponent = publicKey.getPublicExponent();
        BigInteger modulus = publicKey.getModulus();
        String publicKeyString = new String(Base64.getEncoder().encode(publicKey.getEncoded()));
        String privateKeyString = new String(Base64.getEncoder().encode(privateKey.getEncoded()));
        HashMap<Integer, String> keyMap = new HashMap<Integer, String>();
        keyMap.put(0, publicKeyString);
        keyMap.put(1, privateKeyString);
        keyMap.put(2, modulus.toString(16));
        keyMap.put(3, publicExponent.toString(16));
        return keyMap;
    }

    public static String enAES(String str, char[] key) {
        byte[] encrypted = null;
        try {
            encrypted = EncryptUtils.enAES(str.getBytes("utf-8"), key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encrypted == null ? null : Base64.getEncoder().encodeToString(encrypted);
    }

    public static byte[] enAES(byte[] msg, char[] key) {
        byte[] encrypted = null;
        try {
            byte[] raw = StrUtils.toBytes(key);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, skeySpec);
            encrypted = cipher.doFinal(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encrypted;
    }

    public static String deAES(String str, char[] key) {
        String originalString = null;
        byte[] msg = Base64.getDecoder().decode(str);
        byte[] original = EncryptUtils.deAES(msg, key);
        try {
            originalString = new String(original, "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return originalString;
    }

    public static byte[] deAES(byte[] msg, char[] key) {
        byte[] original = null;
        try {
            byte[] raw = StrUtils.toBytes(key);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, skeySpec);
            original = cipher.doFinal(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return original;
    }

    public static char[] randChar(int lenght) {
        char[] result = new char[lenght];
        Character[] chars = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('!'), Character.valueOf('@'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('^'), Character.valueOf('&'), Character.valueOf('*'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('-'), Character.valueOf('='), Character.valueOf('_'), Character.valueOf('+'), Character.valueOf('.')};
        List<Character> list = Arrays.asList(chars);
        Collections.shuffle(list);
        for (int i = 0; i < lenght; ++i) {
            result[i] = list.get(i).charValue();
        }
        return result;
    }
}

