package com.wecloud.rtc.service;

import com.wecloud.im.param.rtc.*;

/**
 * 管理rtc频道
 */
public interface RtcService {

    /**
     * 创建一个频道,并向接收方发送系统推送
     */
    CreateRtcChannelResult createAndCall(CreateRtcChannelParam createRtcChannelParam);

    /**
     * 加入频道
     */
    Boolean join(JoinRtcChannelParam joinRtcChannelParam);

    /**
     * 拒接加入频道
     */
    Boolean reject(RejectRtcChannelParam rejectRtcChannelParam);

    /**
     * 退出频道
     */
    Boolean leave(LeaveRtcChannelParam leaveRtcChannelParam);

    /**
     * SDP数据转发
     *
     * @param sdpForwardParam
     * @return
     */
    Boolean sdpForward(SdpForwardParam sdpForwardParam);

    /**
     * candidate候选者数据转发
     *
     * @param candidateForwardParam
     * @return
     */
    Boolean candidateForward(CandidateForwardParam candidateForwardParam);

}
