package com.wecloud.im.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Map;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 *
 * @Author luozh
 * @Date 2022年05月05日 10:08
 * @Version 1.0
 */
@Data
public class PrivateChatStatusMessageParam {

    /**
     * 发送人客户端id
     */
    @NotEmpty(message = "发送人id不能为空")
    @ApiModelProperty("发送人id")
    private String fromUserId;

    /**
     * 接收用户id
     */
    @NotEmpty(message = "接收用户id不能为空")
    @ApiModelProperty("接收用户id")
    private String toUserIds;

    /**
     * 消息类型
     */
    @NotEmpty(message = "消息类型不能为空")
    @ApiModelProperty("消息类型")
    private String messageType;

    /**
     * 消息
     */
    @NotNull(message = "消息不能为空")
    @ApiModelProperty("消息")
    private Map<String, Object> content;

    /**
     * 是否过滤黑名单
     */
    @ApiModelProperty("是否过滤黑名单")
    private Boolean includeBlacklist;

    /**
     * 发送用户是否接收
     */
    @ApiModelProperty("发送用户是否接收")
    private Boolean includeSender;
}
