package com.wecloud.im.entity;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

import javax.validation.constraints.NotNull;

/**
 * 消息在线推送
 *
 * @author wei
 * @since 2021-04-29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImMessageOnlineSend ")
public class ImMessageOnlineSend extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 消息类型
     * @see com.wecloud.im.ws.enums.MsgTypeEnum
     */
    @ApiModelProperty("消息类型")
    private Integer type;

    @NotNull(message = "消息id不能为空")
    @ApiModelProperty("消息id")
    private Long msgId;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("撤回时间")
    private Date withdrawTime;

    @ApiModelProperty("发送者客户端id")
    private String sender;

    @ApiModelProperty("内容")
    private Object content;

    @ApiModelProperty("0未撤回; 1已撤回")
    private Boolean withdraw;

    @ApiModelProperty("0非事件; 1为事件")
    private Boolean event;

    @ApiModelProperty("0非系统通知; 1为系统通知")
    private Boolean systemFlag;

    @ApiModelProperty("at他人,传入客户端id数组")
    private String at;

    @ApiModelProperty("会话id")
    private Long conversationId;

    @ApiModelProperty("文件")
    private Object file;

}
