package com.wecloud.im.sdk;

import java.net.URL;
import java.util.List;

import com.wecloud.im.sdk.internal.WecloudImClientOperation;
import com.wecloud.im.sdk.model.ClientLoginRequest;
import com.wecloud.im.sdk.model.Friend;
import com.wecloud.im.sdk.model.GetUnsureFriendsRequest;
import com.wecloud.im.sdk.model.ImClient;
import com.wecloud.im.sdk.model.ModifyUserRequest;
import com.wecloud.im.sdk.model.RegisterClientRequest;
import com.wecloud.im.sdk.model.Token;

/**
 *
 * @Author luozh
 * @Date 2022年04月13日 11:23:24
 * @Version 1.0
 */
public class WecloudImClient implements WecloudIm {

    /**
     * 请求地址
     */
    private URL apiDomain;

    /**
     * 蔚可云分配后台分配的appKey
     */
    private String appKey;

    /**
     * 蔚可云分配后台分配的appSecret
     */
    private String appSecret;

    /* The miscellaneous OSS operations */
    private WecloudImClientOperation imClientOperation;

    public WecloudImClient(URL apiDomain, String appKey, String appSecret) {
        this.apiDomain = apiDomain;
        this.appKey = appKey;
        this.appSecret = appSecret;
        initOperations();
    }

    @Override
    public ImClient registerClient(Long userId, String headPortrait, String nickname) {
        RegisterClientRequest registerClientRequest =
                RegisterClientRequest.builder()
                        .userId(userId).headPortrait(headPortrait)
                        .nickname(nickname)
                        .build();
        return imClientOperation.registerClient(registerClientRequest);
    }

    @Override
    public Token getToken(Long userId, Integer deviceType) {
        ClientLoginRequest clientLoginRequest = ClientLoginRequest.builder().clientId(userId).deviceType(deviceType).build();

        return imClientOperation.getToken(clientLoginRequest);
    }

    @Override
    public Boolean modifyUser(Long userId, String nickname, String headPortrait) {
        ModifyUserRequest modifyUserRequest =
                ModifyUserRequest.builder().userId(userId).nickname(nickname).headPortrait(headPortrait).build();

        return imClientOperation.modifyUser(modifyUserRequest);
    }

    @Override
    public List<Friend> getUnsureFriends(Long userId) {
        GetUnsureFriendsRequest getUnsureFriendsRequest = GetUnsureFriendsRequest.builder().userId(userId).build();

        return imClientOperation.getUnsureFriends(getUnsureFriendsRequest);
    }

    private void initOperations() {
        this.imClientOperation = new WecloudImClientOperation(apiDomain, appKey, appSecret);
    }
}
