package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.jumeirah.common.entity.McPlain;
import com.jumeirah.common.param.McPlainPageParam;
import com.jumeirah.common.vo.McPlainQueryVo;

import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;

/**
 * 商家飞机表 Mapper 接口
 *
 * @author xxx
 * @since 2020-10-19
 */
@Repository
public interface McPlainMapper extends BaseMapper<McPlain> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    McPlainQueryVo getMcPlainById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param mcPlainPageParam
     * @param mcId
     * @return
     */
    IPage<McPlainQueryVo> getMcPlainPageList(
            @Param("page") Page page, @Param("param") McPlainPageParam mcPlainPageParam, @Param("mcId") Long mcId);

}
