package com.jumeirah.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.StrokeDiscount;
import com.jumeirah.common.enums.StrokeDiscountStatusEnum;
import com.jumeirah.common.mapper.StrokeDiscountMapper;
import com.jumeirah.common.param.StrokeDiscountPageParam;
import com.jumeirah.common.service.StrokeDiscountService;
import com.jumeirah.common.vo.StrokeDiscountQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 优惠行程表 服务实现类
 *
 * @author xxx
 * @since 2020-10-14
 */
@Slf4j
@Service
public class StrokeDiscountServiceImpl extends BaseServiceImpl<StrokeDiscountMapper, StrokeDiscount> implements StrokeDiscountService {

    @Autowired
    private StrokeDiscountMapper strokeDiscountMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveStrokeDiscount(StrokeDiscount strokeDiscount) throws Exception {
        return super.save(strokeDiscount);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateStrokeDiscount(StrokeDiscount strokeDiscount) throws Exception {
        return super.updateById(strokeDiscount);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteStrokeDiscount(Long id) throws Exception {
        StrokeDiscount strokeDiscount = new StrokeDiscount();
        strokeDiscount.setId(id)
                .setStatus(StrokeDiscountStatusEnum.CANCEL.getCode());
        return super.updateById(strokeDiscount);
    }

    @Override
    public StrokeDiscountQueryVo getStrokeDiscountById(Long id) throws Exception {
        return strokeDiscountMapper.getStrokeDiscountById(id);
    }

    @Override
    public Paging<StrokeDiscountQueryVo> getStrokeDiscountPageList(StrokeDiscountPageParam strokeDiscountPageParam) throws Exception {
        Page<StrokeDiscountQueryVo> page = new PageInfo<>(strokeDiscountPageParam, OrderItem.desc(getLambdaColumn(StrokeDiscount::getCreateTime)));
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        IPage<StrokeDiscountQueryVo> iPage = strokeDiscountMapper.getStrokeDiscountPageList(page, strokeDiscountPageParam, jwtToken.getMcId());
        return new Paging<StrokeDiscountQueryVo>(iPage);
    }

    @Override
    public Paging<StrokeDiscountQueryVo> getAppStrokeDiscountPageList(StrokeDiscountPageParam strokeDiscountPageParam) {
        Page<StrokeDiscountQueryVo> page = new PageInfo<>(strokeDiscountPageParam, OrderItem.desc(getLambdaColumn(StrokeDiscount::getCreateTime)));
        IPage<StrokeDiscountQueryVo> iPage = strokeDiscountMapper.getAppStrokeDiscountPageList(page, strokeDiscountPageParam);
        return new Paging<StrokeDiscountQueryVo>(iPage);
    }

}
