package com.sien.common.service.impl;

import cn.hutool.captcha.generator.RandomGenerator;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.sien.common.entity.AppUser;
import com.sien.common.entity.DonationAgent;
import com.sien.common.entity.DonationRecord;
import com.sien.common.mapper.DonationRecordMapper;
import com.sien.common.param.DonationRecordPageParam;
import com.sien.common.param.app.DonationRecordAdd;
import com.sien.common.service.AppUserService;
import com.sien.common.service.DonationAgentService;
import com.sien.common.service.DonationRecordService;
import com.sien.common.vo.AppUserQueryVo;
import com.sien.common.vo.DonationRankAndTotal;
import com.sien.common.vo.DonationRecordQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 捐款记录 服务实现类
 *
 * @author hewei
 * @since 2021-02-25
 */
@Slf4j
@Service
public class DonationRecordServiceImpl extends BaseServiceImpl<DonationRecordMapper, DonationRecord> implements DonationRecordService {

    private static final String BODY = "厦门市四恩慈善会捐款";

    private static final String NOTIFY_URL = "https://c7a30ed052d8.ngrok.io/api/pay/notify/donationOrder";

    @Autowired
    private DonationRecordMapper donationRecordMapper;

    @Autowired
    private WxPayService wxService;

    @Resource
    HttpServletRequest httpServletRequest;

    @Autowired
    private AppUserService appUserService;

    @Autowired
    private DonationAgentService donationAgentService;

    @Override
    public DonationRankAndTotal getDonationRankAndTotal(Long userId) {
        return donationRecordMapper.getDonationRankAndTotal(userId);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveDonationRecord(DonationRecord donationRecord) throws Exception {
        return super.save(donationRecord);
    }

    @Override
    public String parseDonationOrderNotifyResult(String xmlData) {

        WxPayOrderNotifyResult notifyResult;
        try {
            notifyResult = this.wxService.parseOrderNotifyResult(xmlData);
        } catch (WxPayException e) {
            // 是否能解密成功
            e.printStackTrace();
            return WxPayNotifyResponse.fail("错误");
        }

        DonationRecord donationRecord = super.getOne(new QueryWrapper<DonationRecord>().lambda().eq(DonationRecord::getWxMerPayId, notifyResult.getOutTradeNo()));

        // 如果已经支付 直接响应成功
        if (donationRecord.getPayStatus() == 1) {
            return WxPayNotifyResponse.successResp("成功");

        }

        donationRecord.setPayStatus(1);
        donationRecord.setPayTime(new Date());

        super.updateById(donationRecord);

        return WxPayNotifyResponse.successResp("成功");
        // 根据自己业务场景需要构造返回对象
//        return WxPayNotifyResponse.success("成功");
    }


    @Override
    public ApiResult<WxPayMpOrderResult> add(DonationRecordAdd donationRecordAdd) {

        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        AppUserQueryVo appUserById = null;
        try {
            appUserById = appUserService.getAppUserById(jwtToken.getUserId());
        } catch (Exception e) {
            e.printStackTrace();
            return ApiResult.fail(ApiCode.FAIL, new WxPayMpOrderResult());
        }
        // 用户判空
        if (appUserById == null) {
            return ApiResult.fail(ApiCode.FAIL, new WxPayMpOrderResult());
        }

        // 微信支付请求参数对象
        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();

        String openid = appUserById.getWechatOpenId();
        String spbillCreateIp = httpServletRequest.getRemoteAddr();
        BigDecimal num2 = new BigDecimal(100);
        int totalFee = donationRecordAdd.getMoney().multiply(num2).intValue();

        DonationRecord donationRecord = new DonationRecord();

        // 捐款接收人, 如果为别人捐款
        if (donationRecordAdd.getIsReplace() == 1) {
            AppUser user = appUserService.getOne(new QueryWrapper<AppUser>().lambda()
                    .eq(AppUser::getPhone, donationRecordAdd.getUserPhone())
                    .eq(AppUser::getPhoneArea, donationRecordAdd.getPhoneArea()));

            //判断接收方是否存在
            if (user == null) {
                return ApiResult.fail(ApiCode.FAIL, new WxPayMpOrderResult());
            }
            donationRecord.setFkUserId(user.getId());

        } else {
            donationRecord.setFkUserId(jwtToken.getUserId());
        }

        // 设置捐款记录表
        donationRecord.setMoney(donationRecordAdd.getMoney());
        donationRecord.setPurpose(donationRecordAdd.getPurpose());
        donationRecord.setWay(donationRecordAdd.getWay());
        donationRecord.setIsReplace(donationRecordAdd.getIsReplace());

        String outTradeNo = new RandomGenerator(32).generate();
        donationRecord.setWxMerPayId(outTradeNo);

        // 保存至数据库
        super.save(donationRecord);

        // 为代理捐款 则保存代理记录
        if (donationRecordAdd.getIsReplace() == 1) {
            DonationAgent donationAgent = new DonationAgent();
            donationAgent.setFkUserId(jwtToken.getUserId());
            donationAgent.setFkRecordId(donationRecord.getId());
            donationAgentService.save(donationAgent);
        }

        // 调用微信支付api
        WxPayMpOrderResult order = null;
        try {
            order = getWxPayMpOrderResult(wxPayUnifiedOrderRequest, outTradeNo, openid, spbillCreateIp, totalFee);
        } catch (WxPayException e) {
            e.printStackTrace();
        }

        return ApiResult.ok(order);
    }

    private WxPayMpOrderResult getWxPayMpOrderResult(WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest, String outTradeNo, String openid, String spbillCreateIp, int totalFee) throws WxPayException {
        wxPayUnifiedOrderRequest.setBody(DonationRecordServiceImpl.BODY);

        // 商户系统内部的订单号,32个字符内、可包含字母, 其他说明见商户订单号
        wxPayUnifiedOrderRequest.setOutTradeNo(outTradeNo);

        //订单总金额，单位为分，详见支付金额
        wxPayUnifiedOrderRequest.setTotalFee(totalFee);

        // APP和网页支付提交用户端ip
        wxPayUnifiedOrderRequest.setSpbillCreateIp(spbillCreateIp);

        // 接收微信支付异步通知回调地址，通知url必须为直接可访问的url，不能携带参数。
        wxPayUnifiedOrderRequest.setNotifyUrl(DonationRecordServiceImpl.NOTIFY_URL);

        wxPayUnifiedOrderRequest.setOpenid(openid);
        String jsapi = "JSAPI";
        wxPayUnifiedOrderRequest.setTradeType(jsapi);

        WxPayMpOrderResult order = null;
//        try {
        order = this.wxService.createOrder(wxPayUnifiedOrderRequest);
//        } catch (WxPayException e) {
//            e.printStackTrace();
//        }
        return order;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateDonationRecord(DonationRecord donationRecord) throws Exception {
        return super.updateById(donationRecord);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteDonationRecord(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public DonationRecordQueryVo getDonationRecordById(Long id) throws Exception {
        return donationRecordMapper.getDonationRecordById(id);
    }

    @Override
    public Paging<DonationRecordQueryVo> getDonationRecordPageList(DonationRecordPageParam donationRecordPageParam) throws Exception {

        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();

        Page<DonationRecordQueryVo> page = new PageInfo<>(donationRecordPageParam, OrderItem.desc(getLambdaColumn(DonationRecord::getCreateTime)));
        IPage<DonationRecordQueryVo> iPage = donationRecordMapper.getDonationRecordPageList(page, donationRecordPageParam, jwtToken.getUserId());
        return new Paging<DonationRecordQueryVo>(iPage);
    }

}
