package com.ym.im.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.util.ArrayList;
import java.util.List;

/**
 * @author: JJww
 * @Date:2019-06-13
 */
@Configuration
@EnableSwagger2
public class SwaggerConfig {

    @Bean
    public Docket createRestApi() {
        //全局header参数
        ParameterBuilder authorization = new ParameterBuilder();
        ParameterBuilder col = new ParameterBuilder();
        List<Parameter> pars = new ArrayList<Parameter>();
        authorization.name("Authorization").description("Bearer token").modelRef(new ModelRef("string")).parameterType("header").required(false).build(); //非必传
        col.name("col").description("语言type（英文：en,中文：zh").modelRef(new ModelRef("string")).parameterType("header").required(false).build(); //非必穿
        pars.add(authorization.build());
        pars.add(col.build());
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.ym.im.controller"))
                .paths(PathSelectors.any())
                .build()
                .globalOperationParameters(pars);
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                .title("IM API")
                .version("1.0")
                .build();
    }
}
