package com.wecloud.rtc.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.param.CreateRtcChannelResult;
import com.wecloud.im.param.add.CreateRtcChannelParam;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.service.ImClientService;
import com.wecloud.rtc.service.MangerRtcCacheService;
import com.wecloud.rtc.service.RtcService;
import io.geekidea.springbootplus.framework.shiro.util.SnowflakeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RtcServiceImpl implements RtcService {

    @Autowired
    private ImApplicationService imApplicationService;

    /**
     * redis缓存
     */
    @Autowired
    private MangerRtcCacheService mangerRtcCacheService;

    @Autowired
    private ImClientService imClientService;

    @Override
    public CreateRtcChannelResult createAndCall(CreateRtcChannelParam createRtcChannelParam) throws JsonProcessingException {
        ImClient client = imClientService.getCurentClient();
        Long rtcChannelId = SnowflakeUtil.getId();

        //  根据appKey查询appid
        ImApplication imApplication = imApplicationService.getById(client.getFkAppid());

        mangerRtcCacheService.create(imApplication.getAppKey(), client.getClientId(), rtcChannelId);

        CreateRtcChannelResult createRtcChannelResult = new CreateRtcChannelResult();
        createRtcChannelResult.setChannelId(rtcChannelId);


        // 向对方发送邀请


        return createRtcChannelResult;


    }

    @Override
    public void join() {

    }

    @Override
    public void reject() {

    }

    @Override
    public void leave() {

    }

    @Override
    public void sdpForward() {

    }

    @Override
    public void candidateForward() {

    }
}
