package com.wecloud.im.sdk;

import com.wecloud.im.sdk.model.ImClient;
import com.wecloud.im.sdk.model.Token;

/**
 *
 * @Author luozh
 * @Date 2022年04月13日 11:09
 * @Version 1.0
 */
public interface WecloudIm {

    /**
     * 注册客户端
     * @Author luozh
     * @Date 2022年04月13日 04:25:52
     * @param userId
     * @param headPortrait
     * @param nickname
     * @param deviceType
     * @Return
     * @return
     */
    ImClient registerClient(Long userId, String headPortrait, String nickname);

    /**
     * 获取用户token
     * @Author luozh
     * @Date 2022年04月18日 11:50:44
     * @param userId 用户id
     * @param deviceType 设备类型 1:ios; 2:android; 3:web; 4:win; 5:mac
     * @Return
     */
    Token getToken(Long userId, Integer deviceType);


    /**
     * 修改用户
     * @Author luozh
     * @Date 2022年04月18日 03:29:52
     * @param userId 用户id
     * @param nickname 昵称
     * @param headPortrait 头像
     * @Return
     */
    Boolean modifyUser(Long userId, String nickname, String headPortrait);

}
