package com.wecloud.im.sdk.internal;

import java.net.URL;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.wecloud.im.sdk.common.HttpMethod;
import com.wecloud.im.sdk.common.RequestMessage;
import com.wecloud.im.sdk.model.PublishGroupChatMessageRequest;
import com.wecloud.im.sdk.model.PublishGroupChatStatusMessageRequest;
import com.wecloud.im.sdk.model.PublishPrivateChatMessageRequest;
import com.wecloud.im.sdk.model.PublishPrivateChatStatusMessageRequest;

import static com.wecloud.im.sdk.ResourcePathConstants.PUBLISH_GROUP_CHAT_MESSAGE_REQUEST;
import static com.wecloud.im.sdk.ResourcePathConstants.PUBLISH_GROUP_CHAT_STATUS_MESSAGE_REQUEST;
import static com.wecloud.im.sdk.ResourcePathConstants.PUBLISH_PRIVATE_CHAT_MESSAGE_REQUEST;
import static com.wecloud.im.sdk.ResourcePathConstants.PUBLISH_PRIVATE_CHAT_STATUS_MESSAGE_REQUEST;
import static com.wecloud.im.sdk.utils.CodingUtils.assertParameterNotNull;

/**
 *
 * @Author luozh
 * @Date 2022年05月05日 10:11
 * @Version 1.0
 */
public class WecloudImMessageOperation extends WecloudImOperation {

    public WecloudImMessageOperation(URL apiDomain, String appKey, String appSecret) {
        super(apiDomain, appKey, appSecret);
    }

    /**
     * 发布群消息
     * @Author luozh
     * @Date 2022年05月05日 10:49:47
     * @param publishGroupChatMessageRequest
     * @Return
     */
    public Boolean publishGroupChatMessage(PublishGroupChatMessageRequest publishGroupChatMessageRequest) {
        String fromUserId = publishGroupChatMessageRequest.getFromUserId();
        String toGroupIds = publishGroupChatMessageRequest.getToGroupIds();
        String messageType = publishGroupChatMessageRequest.getMessageType();
        String content = publishGroupChatMessageRequest.getContent();
        // 必填参数校验
        assertParameterNotNull(fromUserId, "fromUserId");
        assertParameterNotNull(toGroupIds, "toGroupIds");
        assertParameterNotNull(messageType, "messageType");
        assertParameterNotNull(content, "content");
        // 校验通过 构建参数
        TypeReference<Map<String, Object>> typeReference = new TypeReference<Map<String, Object>>() {
        };
        Map<String, Object> param = JSONObject.parseObject(JSON.toJSONString(publishGroupChatMessageRequest), typeReference);
        // 发送请求
        RequestMessage request = new WecloudRequestMessageBuilder().setEndpoint(PUBLISH_GROUP_CHAT_MESSAGE_REQUEST)
                .setMethod(HttpMethod.POST).setParameters(param)
                .setOriginalRequest(publishGroupChatMessageRequest).build();
        doOperation(request);
        return true;
    }

    /**
     * 状态消息发送
     * @Author luozh
     * @Date 2022年05月05日 11:07:05
     * @param publishGroupChatStatusMessageRequest
     * @Return
     */
    public Boolean publishGroupChatStatusMessage(PublishGroupChatStatusMessageRequest publishGroupChatStatusMessageRequest) {
        String fromUserId = publishGroupChatStatusMessageRequest.getFromUserId();
        String toGroupIds = publishGroupChatStatusMessageRequest.getToGroupIds();
        String messageType = publishGroupChatStatusMessageRequest.getMessageType();
        String content = publishGroupChatStatusMessageRequest.getContent();
        // 必填参数校验
        assertParameterNotNull(fromUserId, "fromUserId");
        assertParameterNotNull(toGroupIds, "toGroupIds");
        assertParameterNotNull(messageType, "messageType");
        assertParameterNotNull(content, "content");
        // 校验通过 构建参数
        TypeReference<Map<String, Object>> typeReference = new TypeReference<Map<String, Object>>() {
        };
        Map<String, Object> param = JSONObject.parseObject(JSON.toJSONString(publishGroupChatStatusMessageRequest), typeReference);
        // 发送请求
        RequestMessage request = new WecloudRequestMessageBuilder().setEndpoint(PUBLISH_GROUP_CHAT_STATUS_MESSAGE_REQUEST)
                .setMethod(HttpMethod.POST).setParameters(param)
                .setOriginalRequest(publishGroupChatStatusMessageRequest).build();
        doOperation(request);
        return true;
    }

    public Boolean publishPrivateMessage(PublishPrivateChatMessageRequest publishPrivateChatMessageRequest) {
        String fromUserId = publishPrivateChatMessageRequest.getFromUserId();
        String toUserIds = publishPrivateChatMessageRequest.getToUserIds();
        String messageType = publishPrivateChatMessageRequest.getMessageType();
        String content = publishPrivateChatMessageRequest.getContent();
        // 必填参数校验
        assertParameterNotNull(fromUserId, "fromUserId");
        assertParameterNotNull(toUserIds, "toUserIds");
        assertParameterNotNull(messageType, "messageType");
        assertParameterNotNull(content, "content");
        // 校验通过 构建参数
        TypeReference<Map<String, Object>> typeReference = new TypeReference<Map<String, Object>>() {
        };
        Map<String, Object> param = JSONObject.parseObject(JSON.toJSONString(publishPrivateChatMessageRequest), typeReference);
        // 发送请求
        RequestMessage request = new WecloudRequestMessageBuilder().setEndpoint(PUBLISH_PRIVATE_CHAT_MESSAGE_REQUEST)
                .setMethod(HttpMethod.POST).setParameters(param)
                .setOriginalRequest(publishPrivateChatMessageRequest).build();
        doOperation(request);
        return true;
    }

    public Boolean publishPrivateStatusMessage(PublishPrivateChatStatusMessageRequest publishPrivateChatStatusMessageRequest) {
        String fromUserId = publishPrivateChatStatusMessageRequest.getFromUserId();
        String toUserIds = publishPrivateChatStatusMessageRequest.getToUserIds();
        String messageType = publishPrivateChatStatusMessageRequest.getMessageType();
        String content = publishPrivateChatStatusMessageRequest.getContent();
        // 必填参数校验
        assertParameterNotNull(fromUserId, "fromUserId");
        assertParameterNotNull(toUserIds, "toUserIds");
        assertParameterNotNull(messageType, "messageType");
        assertParameterNotNull(content, "content");
        // 校验通过 构建参数
        TypeReference<Map<String, Object>> typeReference = new TypeReference<Map<String, Object>>() {
        };
        Map<String, Object> param = JSONObject.parseObject(JSON.toJSONString(publishPrivateChatStatusMessageRequest), typeReference);
        // 发送请求
        RequestMessage request = new WecloudRequestMessageBuilder().setEndpoint(PUBLISH_PRIVATE_CHAT_STATUS_MESSAGE_REQUEST)
                .setMethod(HttpMethod.POST).setParameters(param)
                .setOriginalRequest(publishPrivateChatStatusMessageRequest).build();
        doOperation(request);
        return true;
    }


}
