/*
 * Decompiled with CFR 0.152.
 */
package com.wecloud.classencrypt;

import com.wecloud.classencrypt.JarDecryptor;
import com.wecloud.classencrypt.util.JarUtils;
import com.wecloud.classencrypt.util.StrUtils;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;

public class AgentTransformer
implements ClassFileTransformer {
    private char[] pwd;

    public AgentTransformer(char[] pwd) {
        this.pwd = pwd;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] classBuffer) {
        if (className == null || domain == null || loader == null) {
            return classBuffer;
        }
        String projectPath = domain.getCodeSource().getLocation().getPath();
        if (StrUtils.isEmpty(projectPath = JarUtils.getRootPath(projectPath))) {
            return classBuffer;
        }
        className = className.replace("/", ".").replace("\\", ".");
        byte[] bytes = JarDecryptor.getInstance().doDecrypt(projectPath, className, this.pwd);
        if (bytes != null && bytes[0] == -54 && bytes[1] == -2 && bytes[2] == -70 && bytes[3] == -66) {
            return bytes;
        }
        return classBuffer;
    }
}

