package com.wecloud.im.ws.enums;

/**
 * @Description ws请求类型
 * @Author hewei hwei1233@163.com
 * @Date 2019-12-05
 */
public enum WsRequestCmdEnum {

    /**
     * 数据
     */
    DATA(1),

    /**
     * ping
     */
    PING(2);


    private final int cmdCode;

    WsRequestCmdEnum(int uriCode) {
        this.cmdCode = uriCode;
    }

    public int getCmdCode() {
        return cmdCode;
    }

    /**
     * 根据uriCode获取
     *
     * @param uriCode
     * @return
     */
    public static WsRequestCmdEnum getByCode(int uriCode) {
        for (WsRequestCmdEnum wsRequestUriPathEnum : values()) {
            if (wsRequestUriPathEnum.getCmdCode() == uriCode) {
                return wsRequestUriPathEnum;
            }
        }
        return null;
    }
}
