package com.ym.im.controller;

import com.ym.im.entity.ChatRecord;
import com.ym.im.entity.MsgBody;
import com.ym.im.entity.PullChatRecord;
import com.ym.im.service.ChatRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.List;

/**
 * @author 陈俊雄
 * @date 2019/5/30
 **/
@RestController
@RequestMapping("/chatRecord")
@Api(description = "聊天记录")
public class ChatRecordController {

    @Autowired
    private ChatRecordService chatRecordService;

    @GetMapping("/pull")
    @ApiOperation(value = "获取聊天记录")
    public MsgBody<PullChatRecord> pull(@Valid PullChatRecord pull) {
        return chatRecordService.getChatRecord(pull);
    }

    @PutMapping("/check")
    @ApiOperation(value = "确认接收")
    public MsgBody<List<ChatRecord>> check(List<ChatRecord> chatRecords) {
        return chatRecordService.updateReceiveTime(chatRecords);
    }

}