package com.wecloud.im.biz.module.message.controller.serverapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.wecloud.can.core.base.controller.BaseController;
import com.wecloud.can.core.enums.ApiCode;
import com.wecloud.can.core.util.ApiResult;
import com.wecloud.im.biz.module.message.controller.param.ApiImConversationMembersPageParam;
import com.wecloud.im.biz.module.message.controller.param.ApiImConversationMembersQueryVo;
import com.wecloud.im.biz.module.message.entity.ImApplication;
import com.wecloud.im.biz.module.message.service.ImApplicationService;
import com.wecloud.im.biz.module.message.service.ImConversationMembersService;

/**
 * 会话成员表 控制器
 *
 * @author wei
 * @since 2021-05-07
 */
@Slf4j
@RestController
@RequestMapping("/server/imConversationMembers")
@Api(value = "服务端rest-API-会话成员表", tags = {"服务端API-会话成员表"})
public class ApiImConversationMembersController extends BaseController {

    @Autowired
    private ImConversationMembersService imConversationMembersService;

    @Autowired
    private ImApplicationService imApplicationService;

    /**
     * 会话成员表分页列表
     */
    @PostMapping("/findList")
    @ApiOperation(value = "rest-api-会话成员表分页列表")
    public ApiResult<List<ApiImConversationMembersQueryVo>> getApiImConversationMembersList(@Validated @RequestBody ApiImConversationMembersPageParam apiImConversationMembersPageParam, @RequestHeader String appkey, @RequestHeader String appSecret) throws Exception {


        //  根据appKey从数据库查询密钥
        ImApplication imApplication = imApplicationService.getCacheAppByAppKey(appkey);

        if (imApplication == null) {
            return ApiResult.result(ApiCode.FAIL, null);
        }

        // 校验appkey 和appSecret
        if (!imApplication.getAppSecret().equals(appSecret)) {
            return ApiResult.result(ApiCode.FAIL, null);
        }
        return imConversationMembersService.getRestApiImConversationMembersList(apiImConversationMembersPageParam, imApplication);
    }


}

