package com.wecloud.im.biz.module.message.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.wecloud.can.core.base.controller.BaseController;
import com.wecloud.can.core.util.ApiResult;
import com.wecloud.can.core.validator.groups.Add;
import com.wecloud.can.datasource.mybatisplus.pagination.Paging;
import com.wecloud.im.biz.module.message.controller.param.ImClientBlacklistPageParam;
import com.wecloud.im.biz.module.message.controller.param.ImClientBlacklistQueryVo;
import com.wecloud.im.biz.module.message.controller.param.add.ImClientBlacklistUpdate;
import com.wecloud.im.biz.module.message.service.ImClientBlacklistService;

/**
 * 黑名单 控制器
 *
 * @author wei
 * @since 2021-06-17
 */
@Slf4j
@RestController
@RequestMapping("/ClientBlacklist")
@Api(value = "黑名单API", tags = {"黑名单"})
public class ImClientBlacklistController extends BaseController {

    @Autowired
    private ImClientBlacklistService imClientBlacklistService;

    /**
     * 添加黑名单
     */
    @PostMapping("/add")
    @ApiOperation(value = "拉入黑名单")
    public ApiResult<Boolean> addImClientBlacklist(@Validated(Add.class) @RequestBody ImClientBlacklistUpdate imClientBlacklistUpdate) throws Exception {
        imClientBlacklistService.addImClientBlacklist(imClientBlacklistUpdate);
        return ApiResult.ok();
    }


    /**
     * 删除黑名单
     */
    @PostMapping("/delete")
    @ApiOperation(value = "移出黑名单")
    public ApiResult<Boolean> deleteImClientBlacklist(@RequestBody ImClientBlacklistUpdate imClientBlacklistUpdate) throws Exception {
        imClientBlacklistService.removeImClientBlacklist(imClientBlacklistUpdate);
        return ApiResult.ok();
    }

    /**
     * 黑名单分页列表
     */
    @PostMapping("/getPageList")
    @ApiOperation(value = "黑名单分页列表")
    public ApiResult<Paging<ImClientBlacklistQueryVo>> getImClientBlacklistPageList(@RequestBody ImClientBlacklistPageParam imClientBlacklistPageParam) throws Exception {
        Paging<ImClientBlacklistQueryVo> blacklist =
                imClientBlacklistService.getImClientBlacklistPageList(imClientBlacklistPageParam);
        return ApiResult.ok(blacklist);
    }

    /**
     * 黑名单分页列表sdk用
     */
    @PostMapping("/sdk/pageBlacklist")
    @ApiOperation(value = "黑名单分页列表")
    public ApiResult<Paging<ImClientBlacklistQueryVo>> getImClientBlacklistPageListSdk(@RequestBody ImClientBlacklistPageParam imClientBlacklistPageParam) throws Exception {
        Paging<ImClientBlacklistQueryVo> blacklist =
                imClientBlacklistService.getImClientBlacklistPageListSdk(imClientBlacklistPageParam);
        return ApiResult.ok(blacklist);
    }

}

