package com.wecloud.im.biz.event;

import lombok.Getter;

import org.springframework.context.ApplicationEvent;

import com.wecloud.im.biz.module.message.entity.ImMessage;

/**
 * 消息发送事件
 * @Author luozh
 * @Date 2022年04月22日 09:40
 * @Version 1.0
 */
@Getter
public class ClientSendMessageEvent extends ApplicationEvent {

    private Long applicationId;

    private ImMessage message;

    /**
     * Create a new {@code ApplicationEvent}.
     * @param source the object on which the event initially occurred or with
     * which the event is associated (never {@code null})
     */
    public ClientSendMessageEvent(Object source) {
        super(source);

    }

    public ClientSendMessageEvent(Long applicationId, ImMessage message) {
        super(message);
        this.applicationId = applicationId;
        this.message = message;
    }

}
