package com.wecloud.im.biz.config;

import org.springframework.stereotype.Component;

import com.wecloud.can.datasource.mybatisplus.OperatorContextService;
import com.wecloud.can.security.jwt.JwtToken;
import com.wecloud.can.security.signature.SignatureAuthToken;
import com.wecloud.can.security.util.JwtUtil;

/**
 *
 * @Author luozh
 * @Date 2022年06月09日 19:22
 * @Version 1.0
 */
@Component
public class OperatorContextServiceImpl implements OperatorContextService<String> {
    @Override
    public String getOperateBy() {
        Object principal = org.apache.shiro.SecurityUtils.getSubject().getPrincipal();
        if (principal instanceof SignatureAuthToken) {
            // 应用端调用
            return "-1";
        } else if (principal instanceof JwtToken) {
            // 客户端调用
            return JwtUtil.getCurrentJwtToken().getFkClientId() + "";
        }
        return "";
    }
}
