package com.wecloud.im.externalaccess.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

/**
 * @Author wenzhida
 * @Date 2022/2/23 15:20
 * @Description 修改性别入参
 */
@Data
public class ModifySexParam implements Serializable {

    private static final long serialVersionUID = -3340451953818782194L;

    /**
     * userId
     */
    @NotNull(message = "userId不可为空")
    @ApiModelProperty("userId")
    private Long userId;

    /**
     * 性别
     * @see com.wecloud.im.sdk.enums.SexEnum
     */
    @NotNull(message = "性别不可为空不可为空")
    @ApiModelProperty("性别 1-男 2-女 3-未知")
    private Integer sex;

}
