package com.wecloud.im.productsconfig;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wecloud.im.entity.ApplicationProductsImConfig;
import com.wecloud.im.service.IApplicationProductsImConfigService;
import com.wecloud.imserver.client.api.ImApplicationProductsConfigFacade;
import com.wecloud.imserver.client.model.ao.ImApplicationProductsConfigAO;
import com.wecloud.imserver.client.model.dto.ImApplicationProductsConfigDTO;
import com.wecloud.imserver.client.model.dto.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author nanqianhao
 * @date 2022/6/9
 * @apiNote
 */
@Slf4j
@Service
@DubboService
public class ImApplicationProductsConfigImpl implements ImApplicationProductsConfigFacade {

    @Autowired
    private IApplicationProductsImConfigService applicationProductsImConfigService;

    @Override
    public Result<Boolean> createOrUpdateImApplicationProductsConfig(ImApplicationProductsConfigAO imApplicationProductsConfigAO) {
        log.info("创建即时通讯应用配置传入参数为{}",imApplicationProductsConfigAO);
        ApplicationProductsImConfig applicationProductsImConfig = new ApplicationProductsImConfig();
        if(imApplicationProductsConfigAO.getFkAppid()==null){
            return Result.getBusinessException("请传入app应用id", null);
        }
        BeanUtils.copyProperties(imApplicationProductsConfigAO,applicationProductsImConfig);
        boolean result = applicationProductsImConfigService.saveOrUpdate(applicationProductsImConfig);
        ImApplicationProductsConfigDTO imApplicationProductsConfigDTO = new ImApplicationProductsConfigDTO();
        BeanUtils.copyProperties(imApplicationProductsConfigDTO,applicationProductsImConfig);
        log.info("生成即时通讯应用配置为{}",imApplicationProductsConfigDTO);
        return Result.getSuccessResult(result);
    }

    @Override
    public Result<ImApplicationProductsConfigDTO> getImApplicationProductsConfig(Long appId) {
        log.info("查看即时通讯应用配置传入appid为{}",appId);
        ApplicationProductsImConfig applicationProductsImConfig = applicationProductsImConfigService.getOne(
                new LambdaQueryWrapper<ApplicationProductsImConfig>().eq(ApplicationProductsImConfig::getFkAppid,appId)
        );
        if (applicationProductsImConfig==null||applicationProductsImConfig.getIsDeleted().equals(true)){
            return Result.getBusinessException("查无此应用配置", null);
        }
        ImApplicationProductsConfigDTO imApplicationProductsConfigDTO = new ImApplicationProductsConfigDTO();
        BeanUtils.copyProperties(applicationProductsImConfig,imApplicationProductsConfigDTO);
        log.info("返回即时通讯应用配置为{}",imApplicationProductsConfigDTO);
        return Result.getSuccessResult(imApplicationProductsConfigDTO);
    }

}
