package com.wecloud.imserver.client.model.ao;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.time.LocalDateTime;

/**
 * @author nanqianhao
 * @date 2022/6/9
 * @apiNote
 */
@Getter
@Setter
@ToString
public class ImApplicationProductsConfigAO extends BaseAO {

    private static final long serialVersionUID = -5277932689556028232L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 应用id
     */
    private Long fkAppid;

    /**
     * 群成员数量上限
     */
    private Integer groupMemberLimit;

    /**
     * 群组数量上限
     */
    private Long groupNumberLimit;

    /**
     * 用户注册数上限
     */
    private Long userRegisterLimit;

    /**
     * 消息存储时长/天
     */
    private Integer messageKeepDays;

    /**
     * 到期时间
     */
    private LocalDateTime expireTime;

    /**
     * 月峰值日活用户
     */
    private Long monthLiveUserMax;

    /**
     * 创建人id
     */
    private Long createBy;

    /**
     * 更新人id
     */
    private Long updateBy;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 是否删除 0否 1是
     */
    private Boolean isDeleted;
}
