package com.wecloud.im.param.rtc;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author nanqianhao
 * @date 2022/5/23
 * @apiNote
 */
@Data
@ApiModel(value = "单人rtc音视频查找记录")
public class SingleRtcRecordParam implements Serializable {

    private static final long serialVersionUID = 2176804812523348248L;

    /**
     * 发送者id
     */
    @ApiModelProperty("发送者id")
    private String fromClientId;

    /**
     * 接受者id
     */
    @ApiModelProperty("接受者id")
    private String toClientId;

    /**
     * 房间id
     */
    @ApiModelProperty("房间id")
    private String channelId;

    /**
     * 音视频类型
     * @see com.wecloud.im.sdk.enums.CallTypeEnum
     */
    @ApiModelProperty("音视频类型")
    private Integer callType;

    /***
     * 页码
     */
    @ApiModelProperty("页码")
    private Integer pageNum;

    /**
     * 每页数量
     */
    @ApiModelProperty("每页数量")
    private Integer pageSize;

    @ApiModelProperty("开始时间")
    private Date createTimeStart;

    @ApiModelProperty("结束时间")
    private Date createTimeEnd;

}
