package com.wecloud.im.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImRtcRecord;
import com.wecloud.im.param.rtc.SingleRtcRecordParam;
import com.wecloud.im.service.ImRtcRecordService;
import com.wecloud.im.vo.MissedRtcRecordVO;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author nanqianhao
 * @date 2022/5/23
 * @apiNote
 */
@Slf4j
@RestController
@RequestMapping("/rtcRecord")
@Api(value = "通话记录控制器")
public class ImRtcRecordController extends BaseController {

    @Autowired
    private ImRtcRecordService rtcRecordService;

    @PostMapping("/listRtcRecords")
    @ApiOperation(value = "分页获取通话记录")
    public ApiResult<Page<ImRtcRecord>> listRtcRecords(@RequestBody SingleRtcRecordParam singleRtcRecordParam) {
        log.info("分页获取通话记录入参 {}", JSON.toJSONString(singleRtcRecordParam));
        return ApiResult.ok(rtcRecordService.getPageImRtcRecords(singleRtcRecordParam));
    }

    @ApiOperation("未接音视频")
    @GetMapping("/missedConversation")
    ApiResult<MissedRtcRecordVO> missedConversation(@RequestParam("userId") String userId){
        MissedRtcRecordVO missedRtcRecord = rtcRecordService.getMissedRtcRecord(userId);
        // 如果没有记录 则状态为4
        if (missedRtcRecord==null){
            MissedRtcRecordVO missedRtcRecordVO = new MissedRtcRecordVO();
            missedRtcRecordVO.setState(4);
            return ApiResult.ok(missedRtcRecordVO);
        }
        return ApiResult.ok(missedRtcRecord);
    }

}
