package com.wecloud.im.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author wenzhida
 * @Date 2022/3/7 19:09
 * @Description 邀请加入多人会议室
 */
@Data
@ApiModel(value = "邀请加入多人会议室")
public class InviteToMultiMeetParam implements Serializable {


    private static final long serialVersionUID = 6815250319056125934L;

    @ApiModelProperty(value = "绑定的会话id,可选", required = false)
    private Long conversationId;

    @ApiModelProperty(value = "多人会议房间id", required = true)
    private String roomId;

    @ApiModelProperty(value = "被邀请的客户端ID列表", required = true)
    private List<String> toClients;

    @ApiModelProperty(value = "接收方展示的系统推送内容", required = false)
    private String push;

    @ApiModelProperty(value = "是否需要给对方发系统通知", required = true)
    private Boolean pushCall;

}
