package com.wecloud.im.sdk.enums;

import lombok.Getter;

/**
 *
 * @Author luozh
 * @Date 2022年05月07日 13:44
 * @Version 1.0
 */
public enum MessageTypeEnum {

    // 位置
    POSITION(0),
    // 文本消息
    TEXT(-1),
    // 图像消息
    IMAGE(-2),
    // 音频消息
    AUDIO(-3),
    // 视频消息
    VIDEO(-4),
    // 文件消息
    FILE(-5),
    ;

    @Getter
    private final int code;

    MessageTypeEnum(int code) {
        this.code = code;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static MessageTypeEnum getByCode(int code) {
        for (MessageTypeEnum messageTypeEnum : values()) {
            if (messageTypeEnum.getCode() == code) {
                return messageTypeEnum;
            }
        }
        return null;
    }

}
