package com.jumeirah.common.entity;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import io.geekidea.springbootplus.framework.core.validator.groups.Update;

import java.sql.Timestamp;

/**
 * 飞机型号表
 *
 * @author wei
 * @since 2020-10-09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "PlainType对象")
public class PlainType extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {Update.class})
    @ApiModelProperty("主键ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @NotNull(message = "系列类型不能为空")
    @ApiModelProperty("系列类型")
    private Integer seriesType;

    @ApiModelProperty("系列名称")
    private String seriesName;


    @NotBlank(message = "飞机名称不能为空")
    @ApiModelProperty("飞机名称")
    private String name;

    @NotBlank(message = "飞机图片地址不能为空")
    @ApiModelProperty("飞机图片地址")
    private String imgUrl;

    @NotNull(message = "状态，0-正常，1-禁用，99-删除不能为空")
    @ApiModelProperty("状态，0-正常，1-禁用，99-删除")
    private Integer status;

    @NotNull(message = "创建时间（时间戳）不能为空")
    @ApiModelProperty("创建时间（时间戳）")
    private Timestamp createTime;

    @ApiModelProperty("更新时间（时间戳）")
    private Timestamp updateTime;

    @ApiModelProperty("宽 单位：像素")
    private Integer width;

    @ApiModelProperty("高 单位：像素")
    private Integer height;

}
