package com.jumeirah.api.app.controller;

import com.jumeirah.common.param.BusinessPlainPageParam;
import com.jumeirah.common.service.BusinessPlainService;
import com.jumeirah.common.vo.BusinessPlainQueryForAppVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 公务机出售托管表 控制器
 *
 * @author giao
 * @since 2020-10-14
 */
@Slf4j
@RestController
@RequestMapping("/app/businessPlain")
@Api(value = "公务机出售托管表API", tags = {"公务机出售托管表"})
public class BusinessPlainForAppController extends BaseController {

    @Autowired
    private BusinessPlainService businessPlainService;

//    /**
//     * 添加公务机出售托管表
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加公务机出售托管表", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加公务机出售托管表")
//    public ApiResult<Boolean> addBusinessPlain(@Validated(Add.class) @RequestBody BusinessPlain businessPlain) throws Exception {
//        boolean flag = businessPlainService.saveBusinessPlain(businessPlain);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 修改公务机出售托管表
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改公务机出售托管表", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改公务机出售托管表")
//    public ApiResult<Boolean> updateBusinessPlain(@Validated(Update.class) @RequestBody BusinessPlain businessPlain) throws Exception {
//        boolean flag = businessPlainService.updateBusinessPlain(businessPlain);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除公务机出售托管表
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除公务机出售托管表", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除公务机出售托管表")
//    public ApiResult<Boolean> deleteBusinessPlain(@PathVariable("id") Long id) throws Exception {
//        boolean flag = businessPlainService.deleteBusinessPlain(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取公务机出售托管表详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "公务机出售托管表详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "公务机出售托管表详情")
//    public ApiResult<BusinessPlainQueryVo> getBusinessPlain(@PathVariable("id") Long id) throws Exception {
//        BusinessPlainQueryVo businessPlainQueryVo = businessPlainService.getBusinessPlainById(id);
//        return ApiResult.ok(businessPlainQueryVo);
//    }

    /**
     * 公务机出售托管表分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "公务机出售托管表分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "公务机出售托管表分页列表")
    public ApiResult<Paging<BusinessPlainQueryForAppVo>> getBusinessPlainPageList(@Validated @RequestBody BusinessPlainPageParam businessPlainPageParam) throws Exception {
        Paging<BusinessPlainQueryForAppVo> paging = businessPlainService.getBusinessPlainPageListForApp(businessPlainPageParam);
        return ApiResult.ok(paging);
    }

}

