package com.jumeirah.common.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <pre>
 * 系统通知表 查询结果对象
 * </pre>
 *
 * @author xxx
 * @date 2020-11-06
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "SysNoticeQueryVo对象")
public class SysNoticeQueryVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("主题")
    private String theme;

    @ApiModelProperty("内容")
    private String msgInfo;

    @ApiModelProperty("创建时间（时间戳）")
    private Date sendTime;

    private Long sendReceive = 1L;//0:用户 1:客服
    private Long msgType = 0L;//0、聊天信息，1、图片，2、视频，4、文件，5、订单
    private Long merchantId = 0L;//商户ID 给个0

}