package com.jumeirah.api.merchant.controller;

import com.jumeirah.common.entity.MerchantRolePermission;
import com.jumeirah.common.param.MerchantRolePermissionPageParam;
import com.jumeirah.common.service.MerchantRolePermissionService;
import com.jumeirah.common.vo.MerchantRolePermissionQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.Module;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商家角色权限关系 控制器
 *
 * @author wei
 * @since 2020-09-27
 */
@Slf4j
@RestController
@RequestMapping("/merchant/rolePermission")
@Module("${cfg.module}")
@Api(value = "商家角色权限关系API", tags = {"商家角色权限关系"})
public class MerchantRolePermissionController extends BaseController {

    @Autowired
    private MerchantRolePermissionService merchantRolePermissionService;

    /**
     * 添加商家角色权限关系
     */
    @PostMapping("/add")
    @OperationLog(name = "添加商家角色权限关系", type = OperationLogType.ADD)
    @ApiOperation(value = "添加商家角色权限关系", response = ApiResult.class)
    public ApiResult<Boolean> addMerchantRolePermission(@Validated(Add.class) @RequestBody MerchantRolePermission merchantRolePermission) throws Exception {
        boolean flag = merchantRolePermissionService.saveMerchantRolePermission(merchantRolePermission);
        return ApiResult.result(flag);
    }

    /**
     * 修改商家角色权限关系
     */
    @PostMapping("/update")
    @OperationLog(name = "修改商家角色权限关系", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改商家角色权限关系", response = ApiResult.class)
    public ApiResult<Boolean> updateMerchantRolePermission(@Validated(Update.class) @RequestBody MerchantRolePermission merchantRolePermission) throws Exception {
        boolean flag = merchantRolePermissionService.updateMerchantRolePermission(merchantRolePermission);
        return ApiResult.result(flag);
    }

    /**
     * 删除商家角色权限关系
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除商家角色权限关系", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除商家角色权限关系", response = ApiResult.class)
    public ApiResult<Boolean> deleteMerchantRolePermission(@PathVariable("id") Long id) throws Exception {
        boolean flag = merchantRolePermissionService.deleteMerchantRolePermission(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取商家角色权限关系详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "商家角色权限关系详情", type = OperationLogType.INFO)
    @ApiOperation(value = "商家角色权限关系详情", response = MerchantRolePermissionQueryVo.class)
    public ApiResult<MerchantRolePermissionQueryVo> getMerchantRolePermission(@PathVariable("id") Long id) throws Exception {
        MerchantRolePermissionQueryVo merchantRolePermissionQueryVo = merchantRolePermissionService.getMerchantRolePermissionById(id);
        return ApiResult.ok(merchantRolePermissionQueryVo);
    }

    /**
     * 商家角色权限关系分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "商家角色权限关系分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "商家角色权限关系分页列表", response = MerchantRolePermissionQueryVo.class)
    public ApiResult<Paging<MerchantRolePermissionQueryVo>> getMerchantRolePermissionPageList(@Validated @RequestBody MerchantRolePermissionPageParam merchantRolePermissionPageParam) throws Exception {
        Paging<MerchantRolePermissionQueryVo> paging = merchantRolePermissionService.getMerchantRolePermissionPageList(merchantRolePermissionPageParam);
        return ApiResult.ok(paging);
    }

}

