package com.jumeirah.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.AppUser;
import com.jumeirah.common.mapper.AppUserMapper;
import com.jumeirah.common.param.AppUserPageParam;
import com.jumeirah.common.param.RegisterParam;
import com.jumeirah.common.service.AppUserService;
import com.jumeirah.common.vo.AppUserQueryVo;
import com.jumeirah.common.vo.LoginSysUserTokenVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * APP用户 服务实现类
 *
 * @author wei
 * @since 2020-09-23
 */
@Slf4j
@Service
public class AppUserServiceImpl extends BaseServiceImpl<AppUserMapper, AppUser> implements AppUserService {

    @Autowired
    private AppUserMapper appUserMapper;

    @Override
    public ApiResult<LoginSysUserTokenVo> register(RegisterParam registerParam, String language) {
        return null;
    }

    @Override
    public ApiResult<LoginSysUserTokenVo> phoneLogin(RegisterParam registerParam, String language) {
        return null;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveAppUser(AppUser appUser) throws Exception {
        return super.save(appUser);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateAppUser(AppUser appUser) throws Exception {
        return super.updateById(appUser);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteAppUser(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public AppUserQueryVo getAppUserById(Long id) throws Exception {
        return appUserMapper.getAppUserById(id);
    }

    @Override
    public Paging<AppUserQueryVo> getAppUserPageList(AppUserPageParam appUserPageParam) throws Exception {
        Page<AppUserQueryVo> page = new PageInfo<>(appUserPageParam, OrderItem.desc(getLambdaColumn(AppUser::getCreateTime)));
        IPage<AppUserQueryVo> iPage = appUserMapper.getAppUserPageList(page, appUserPageParam);
        return new Paging<AppUserQueryVo>(iPage);
    }

}
