package com.jumeirah.api.app.controller;

import com.jumeirah.common.entity.AppUser;
import com.jumeirah.common.param.AppUserPageParam;
import com.jumeirah.common.param.RegisterParam;
import com.jumeirah.common.service.AppUserService;
import com.jumeirah.common.vo.AppUserQueryVo;
import com.jumeirah.common.vo.LoginSysUserTokenVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.Module;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.annotation.OperationLogIgnore;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

/**
 * APP用户 控制器
 *
 * @author wei
 * @since 2020-09-23
 */
@Slf4j
@RestController
@Module("api-app")
@Api(value = "用户API", tags = {"APP相关"})
@RequestMapping("/app/user/")
public class AppUserController extends BaseController {

    @Autowired
    private AppUserService appUserService;

    /**
     * 添加APP用户
     */
    @PostMapping("/add")
    @OperationLog(name = "添加APP用户", type = OperationLogType.ADD)
    @ApiOperation(value = "添加APP用户", response = ApiResult.class)
    public ApiResult<Boolean> addAppUser(@Validated(Add.class) @RequestBody AppUser appUser) throws Exception {
        boolean flag = appUserService.saveAppUser(appUser);
        return ApiResult.result(flag);
    }

    /**
     * 修改APP用户
     */
    @PostMapping("/update")
    @OperationLog(name = "修改APP用户", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改APP用户", response = ApiResult.class)
    public ApiResult<Boolean> updateAppUser(@Validated(Update.class) @RequestBody AppUser appUser) throws Exception {
        boolean flag = appUserService.updateAppUser(appUser);
        return ApiResult.result(flag);
    }

    /**
     * 删除APP用户
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除APP用户", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除APP用户", response = ApiResult.class)
    public ApiResult<Boolean> deleteAppUser(@PathVariable("id") Long id) throws Exception {
        boolean flag = appUserService.deleteAppUser(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取APP用户详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "APP用户详情", type = OperationLogType.INFO)
    @ApiOperation(value = "APP用户详情", response = AppUserQueryVo.class)
    public ApiResult<AppUserQueryVo> getAppUser(@PathVariable("id") Long id) throws Exception {
        AppUserQueryVo appUserQueryVo = appUserService.getAppUserById(id);
        return ApiResult.ok(appUserQueryVo);
    }

    /**
     * APP用户分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "APP用户分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "APP用户分页列表", response = AppUserQueryVo.class)
    public ApiResult<Paging<AppUserQueryVo>> getAppUserPageList(@Validated @RequestBody AppUserPageParam appUserPageParam) throws Exception {
        Paging<AppUserQueryVo> paging = appUserService.getAppUserPageList(appUserPageParam);
        return ApiResult.ok(paging);
    }


    @PostMapping("/register")
    @OperationLogIgnore
    @ApiOperation(value = "注册", notes = "web用户注册", response = LoginSysUserTokenVo.class)
    public ApiResult<LoginSysUserTokenVo> register(@Validated @RequestBody RegisterParam registerParam, HttpServletResponse response, @RequestHeader(required = false) String language) throws Exception {
        return appUserService.register(registerParam, language);

    }

    @PostMapping("/phoneLogin")
    @OperationLogIgnore
    @ApiOperation(value = "手机号登陆", notes = "手机号登陆", response = LoginSysUserTokenVo.class)
    public ApiResult<LoginSysUserTokenVo> phoneLogin(@Validated @RequestBody RegisterParam registerParam, HttpServletResponse response, @RequestHeader(required = false) String language) throws Exception {
        return appUserService.register(registerParam, language);
    }
}

