package com.wecloud.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImClientBlacklist;
import com.wecloud.im.mapper.ImClientBlacklistMapper;
import com.wecloud.im.param.ImClientBlacklistPageParam;
import com.wecloud.im.param.ImClientBlacklistQueryVo;
import com.wecloud.im.param.add.ImClientBlacklistUpdate;
import com.wecloud.im.service.ImClientBlacklistService;
import com.wecloud.im.service.ImClientService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.shiro.util.SnowflakeUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * 黑名单 服务实现类
 *
 * @author wei
 * @since 2021-06-17
 */
@Slf4j
@Service
public class ImClientBlacklistServiceImpl extends BaseServiceImpl<ImClientBlacklistMapper, ImClientBlacklist> implements ImClientBlacklistService {

    @Autowired
    private ImClientBlacklistMapper imClientBlacklistMapper;

    @Autowired
    private ImClientService imClientService;

    @Override
    public boolean isBeBlack(Long currentClient, Long toClient) {
        ImClientBlacklist one = this.getOne(new QueryWrapper<ImClientBlacklist>().lambda()
                .eq(ImClientBlacklist::getFkClientIdPrevent, currentClient)
                .eq(ImClientBlacklist::getFkClientIdBePrevent, toClient));

        return one != null;
    }

    @Override
    public ApiResult<Boolean> addImClientBlacklist(ImClientBlacklistUpdate imClientBlacklistUpdate) throws Exception {
        ImClient client = imClientService.getClient();

        ImClient client1 = imClientService.getOne(new QueryWrapper<ImClient>().lambda()
                .eq(ImClient::getFkAppid, client.getFkAppid())
                .eq(ImClient::getClientId, imClientBlacklistUpdate.getClientIdBePrevent()));


        ImClientBlacklist imClientBlacklist = new ImClientBlacklist();
        imClientBlacklist.setId(SnowflakeUtil.getId());
        imClientBlacklist.setCreateTime(new Date());
        imClientBlacklist.setFkAppid(client.getFkAppid());
        imClientBlacklist.setFkClientIdPrevent(client.getId());
        imClientBlacklist.setFkClientIdBePrevent(client1.getId());

        boolean save = this.save(imClientBlacklist);

        return ApiResult.ok();
    }

    @Override
    public ApiResult<Boolean> removeImClientBlacklist(ImClientBlacklistUpdate imClientBlacklistUpdate) throws Exception {
        ImClient client = imClientService.getClient();

        ImClient client1 = imClientService.getOne(new QueryWrapper<ImClient>().lambda()
                .eq(ImClient::getFkAppid, client.getFkAppid())
                .eq(ImClient::getClientId, imClientBlacklistUpdate.getClientIdBePrevent()));

        ImClientBlacklist one = this.getOne(new QueryWrapper<ImClientBlacklist>().lambda()
                .eq(ImClientBlacklist::getFkClientIdPrevent, client.getId())
                .eq(ImClientBlacklist::getFkClientIdBePrevent, client1.getId()));

        this.deleteImClientBlacklist(one.getId());

        return ApiResult.ok();
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveImClientBlacklist(ImClientBlacklist imClientBlacklist) throws Exception {
        return super.save(imClientBlacklist);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateImClientBlacklist(ImClientBlacklist imClientBlacklist) throws Exception {
        return super.updateById(imClientBlacklist);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteImClientBlacklist(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public ImClientBlacklistQueryVo getImClientBlacklistById(Long id) throws Exception {
        return imClientBlacklistMapper.getImClientBlacklistById(id);
    }

//    @Override
//    public Paging<ImClientBlacklistQueryVo> getImClientBlacklistPageList(ImClientBlacklistPageParam imClientBlacklistPageParam) throws Exception {
//        Page<ImClientBlacklistQueryVo> page = new PageInfo<>(imClientBlacklistPageParam, OrderItem.desc(getLambdaColumn(ImClientBlacklist::getCreateTime)));
//        IPage<ImClientBlacklistQueryVo> iPage = imClientBlacklistMapper.getImClientBlacklistPageList(page, imClientBlacklistPageParam);
//        return new Paging<ImClientBlacklistQueryVo>(iPage);
//    }

    @Override
    public ApiResult<Paging<ImClientBlacklistQueryVo>> getImClientBlacklistPageList(ImClientBlacklistPageParam imClientBlacklistPageParam) throws Exception {

        Page<ImClientBlacklistQueryVo> page = new PageInfo<>(imClientBlacklistPageParam, OrderItem.desc(getLambdaColumn(ImClientBlacklist::getCreateTime)));

        ImClient client = imClientService.getClient();

        IPage<ImClientBlacklistQueryVo> imClientBlacklistPageList = imClientBlacklistMapper.getImClientBlacklistPageList(page, client.getId());

        Paging<ImClientBlacklistQueryVo> imClientBlacklistQueryVoPaging = new Paging<>(imClientBlacklistPageList);

        return ApiResult.ok(imClientBlacklistQueryVoPaging);
    }

}
