package com.wecloud.im.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImConversation;
import com.wecloud.im.param.ImConversationPageParam;
import com.wecloud.im.param.ImConversationQueryVo;
import com.wecloud.im.vo.MyConversationListVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;
import java.util.List;

/**
 * 会话表 Mapper 接口
 *
 * @author wei
 * @since 2021-05-07
 */
@Repository
public interface ImConversationMapper extends BaseMapper<ImConversation> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    ImConversationQueryVo getImConversationById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param imConversationPageParam
     * @return
     */
    IPage<ImConversationQueryVo> getImConversationPageList(@Param("page") Page page, @Param("param") ImConversationPageParam imConversationPageParam);


    /**
     * 查询用户加入的所有会话 与每个会话的未读条数 成员
     *
     * @param clientId
     * @return
     */
    List<MyConversationListVo> getMyImConversationListAndMsgCount(@Param("clientId") Long clientId);

    /**
     * 查询用户加入的所有会话
     *
     * @param clientId
     * @return
     */
    List<ImConversation> getMyImConversationList(@Param("clientId") Long clientId);

    /**
     * 判断两个客户端是否存在会话
     *
     * @param clientId1
     * @param clientId2
     * @return
     */
    Integer getRepetitionConversation(@Param("clientId1") Long clientId1, @Param("clientId2") Long clientId2);
}
