package com.wecloud.dispatch.util;

import com.wecloud.dispatch.extend.ActionRequest;

/**
 * 记录websocket请求详情信息到当前线程中
 * @Author luozh
 * @Date 2022年04月03日 23:14
 * @Version 1.0
 */
public class ActionRequestHolder {

    private static final ThreadLocal<ActionRequest> THREAD_LOCAL = new ThreadLocal<>();

    /**
     * 从当前线程中获取请求信息
     */
    public static ActionRequest getActionRequest() {
        return THREAD_LOCAL.get();
    }

    /**
     * 设置请求信息到当前线程中
     *
     * @param actionRequest
     */
    public static void setActionRequest(ActionRequest actionRequest) {
        THREAD_LOCAL.set(actionRequest);
    }

    /**
     * 销毁
     */
    public static void remove() {
        THREAD_LOCAL.remove();
    }
}
