package com.jumeirah.api.merchant.controller.management;

import com.jumeirah.common.param.McStrokePaymentPageParam;
import com.jumeirah.common.service.StrokeService;
import com.jumeirah.common.vo.McStrokePaymentQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 行程表 控制器
 *
 * @author wei
 * @since 2020-09-29
 */
@Slf4j
@RestController
@RequestMapping("/merchant/payment")
@Api(value = "财务管理API", tags = {"财务管理"})
public class McStrokePaymentController extends BaseController {

    @Autowired
    private StrokeService strokeService;

    /**
     * 收款记录
     */
    @PostMapping("/pageList")
    @OperationLog(name = "收款记录", type = OperationLogType.PAGE)
    @ApiOperation(value = "收款记录")
    @RequiresPermissions("merchant:order:view")
    public ApiResult<Paging<McStrokePaymentQueryVo>> getPaymentPageList(@Validated @RequestBody McStrokePaymentPageParam mcStrokePaymentPageParam) throws Exception {
        Paging<McStrokePaymentQueryVo> paging = strokeService.getPaymentPageList(mcStrokePaymentPageParam);
        return ApiResult.ok(paging);
    }


}

