package com.wecloud.dispatch.extend.impl;

import com.wecloud.dispatch.extend.ActionBox;
import com.wecloud.dispatch.factory.ObjectFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lixiaozhong
 */
public class DefaultActionBox implements ActionBox {

	Map<String, Class<?>> classMap = new HashMap<>();
	ObjectFactory objectFactory = new ObjectFactory();

	@Override
	public Object getAction(Class<?> type) {
		return objectFactory.getObject(type);
	}

	@Override
	public Object getAction(String className) {
		Class<?> type = null;
		if (classMap.containsKey(className)) {
			type = classMap.get(className);
		} else {
			try {
				type = Class.forName(className);
				classMap.put(className, type);
			} catch (Exception e) {
				classMap.put(className, null);
			}
		}
		if (null == type) {
			return null;
		} else {
			return getAction(type);
		}
	}
}
