package com.wecloud.im.biz.scheduled;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import com.wecloud.im.biz.module.multimeet.service.MultiMeetService;

/**
 * @Author wenzhida
 * @Date 2022/3/28 16:34
 * @Description 多人音视频相关定时器
 */
@Slf4j
@Component
public class MultiMeetScheduled {

    @Autowired
    private MultiMeetService multiMeetService;

    /**
     * 呼叫超时处理
     * 每5秒执行一次
     */
    @Scheduled(cron = "*/5 * * * * ?")
    public void callingTimeout() {
        log.info("呼叫超时处理开始...");
        multiMeetService.callingTimeout();
    }

    /**
     * 接听中成员异常断线处理
     * 每10秒执行一次 (5秒一次心跳 - 20秒未收到心跳，认为已经异常断开连接)
     */
    @Scheduled(cron = "*/10 * * * * ?")
    public void disconnect() {
        log.info("异常断线处理开始...");
        multiMeetService.disconnect();
    }

}
