package com.wecloud.im.biz.module.rtc.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.wecloud.can.core.enums.ApiCode;
import com.wecloud.can.core.util.ApiResult;
import com.wecloud.im.biz.module.rtc.entity.response.RtcCallResponse;
import com.wecloud.im.biz.module.rtc.entity.response.RtcCandidateForwardResponse;
import com.wecloud.im.biz.module.rtc.entity.response.RtcClientJoinResponse;
import com.wecloud.im.biz.module.rtc.entity.response.RtcClientLeaveResponse;
import com.wecloud.im.biz.module.rtc.entity.response.RtcClientRejectResponse;
import com.wecloud.im.biz.module.rtc.entity.response.RtcSdpForwardResponse;
import com.wecloud.im.biz.module.rtc.service.WsRtcWrite;
import com.wecloud.im.server.enums.WsResponseCmdEnum;
import com.wecloud.im.server.enums.WsRtcResponseSubCmdEnum;
import com.wecloud.im.server.model.WsResponse;
import com.wecloud.im.server.sender.ChannelSender;

@Service
public class WsRtcWriteImpl implements WsRtcWrite {

    @Autowired
    private ChannelSender channelSender;

    @Override
    public void rtcCall(RtcCallResponse rtcCallResponse, Long toClientId) {
        rtcCallResponse.setSubCmd(WsRtcResponseSubCmdEnum.RTC_CALL.getCmdCode());

        //  向接收方推送
        WsResponse<RtcCallResponse> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.SINGLE_RTC_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(rtcCallResponse);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toClientId);
    }

    @Override
    public void clientJoin(RtcClientJoinResponse rtcClientJoinResponse, Long toClientId) {
        rtcClientJoinResponse.setSubCmd(WsRtcResponseSubCmdEnum.CLIENT_JOIN.getCmdCode());

        //  向接收方推送
        WsResponse<RtcClientJoinResponse> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.SINGLE_RTC_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(rtcClientJoinResponse);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toClientId);
    }

    @Override
    public void clientLeave(RtcClientLeaveResponse rtcClientLeaveResponse, Long toClientId) {
        rtcClientLeaveResponse.setSubCmd(WsRtcResponseSubCmdEnum.CLIENT_LEAVE.getCmdCode());

        //  向接收方推送
        WsResponse<RtcClientLeaveResponse> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.SINGLE_RTC_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(rtcClientLeaveResponse);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toClientId);
    }

    @Override
    public void clientReject(RtcClientRejectResponse rtcClientRejectResponse, Long toClientId) {
        rtcClientRejectResponse.setSubCmd(WsRtcResponseSubCmdEnum.CLIENT_REJECT.getCmdCode());

        //  向接收方推送
        WsResponse<RtcClientRejectResponse> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.SINGLE_RTC_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(rtcClientRejectResponse);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toClientId);
    }

    @Override
    public void sdpForward(RtcSdpForwardResponse rtcSdpForwardResponse, Long toClientId) {
        rtcSdpForwardResponse.setSubCmd(WsRtcResponseSubCmdEnum.SDP_FORWARD.getCmdCode());

        //  向接收方推送
        WsResponse<RtcSdpForwardResponse> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.SINGLE_RTC_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(rtcSdpForwardResponse);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toClientId);
    }

    @Override
    public void candidateForward(RtcCandidateForwardResponse rtcCandidateForwardResponse, Long toClientId) {
        rtcCandidateForwardResponse.setSubCmd(WsRtcResponseSubCmdEnum.CANDIDATE_FORWARD.getCmdCode());

        //  向接收方推送
        WsResponse<RtcCandidateForwardResponse> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.SINGLE_RTC_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(rtcCandidateForwardResponse);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toClientId);
    }

}
