package com.wecloud.im.biz.module.message.service.impl;

import lombok.extern.slf4j.Slf4j;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.can.core.exception.BusinessException;
import com.wecloud.can.core.util.SnowflakeUtil;
import com.wecloud.can.datasource.mybatisplus.pagination.PageInfo;
import com.wecloud.can.datasource.mybatisplus.pagination.Paging;
import com.wecloud.can.datasource.mybatisplus.service.impl.BaseServiceImpl;
import com.wecloud.can.security.util.SecurityUtils;
import com.wecloud.im.biz.module.message.controller.param.ImClientBlacklistPageParam;
import com.wecloud.im.biz.module.message.controller.param.ImClientBlacklistQueryVo;
import com.wecloud.im.biz.module.message.controller.param.add.ImClientBlacklistUpdate;
import com.wecloud.im.biz.module.message.entity.ImClient;
import com.wecloud.im.biz.module.message.entity.ImClientBlacklist;
import com.wecloud.im.biz.module.message.mapper.ImClientBlacklistMapper;
import com.wecloud.im.biz.module.message.service.ContextService;
import com.wecloud.im.biz.module.message.service.ImClientBlacklistService;
import com.wecloud.im.biz.module.message.service.ImClientService;

/**
 * 黑名单 服务实现类
 *
 * @author wei
 * @since 2021-06-17
 */
@Slf4j
@Service
public class ImClientBlacklistServiceImpl extends BaseServiceImpl<ImClientBlacklistMapper, ImClientBlacklist> implements ImClientBlacklistService {

    @Autowired
    private ImClientBlacklistMapper imClientBlacklistMapper;

    @Autowired
    private ImClientService imClientService;

    @Autowired
    private ContextService contextService;

    @Override
    public boolean isBeBlack(String currentClientId, String toClientId) {
        ImClientBlacklist one = this.getOne(new QueryWrapper<ImClientBlacklist>().lambda()
                .eq(ImClientBlacklist::getClientIdPrevent, currentClientId)
                .eq(ImClientBlacklist::getClientIdBePrevent, toClientId));

        return one != null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean addImClientBlacklist(ImClientBlacklistUpdate imClientBlacklistUpdate) {
        ImClient currentClient = contextService.getImClientIfNotNullOrThrow();
        ImClient beBlacker = imClientService.getOne(new QueryWrapper<ImClient>().lambda()
                .eq(ImClient::getFkAppid, currentClient.getFkAppid())
                .eq(ImClient::getClientId, imClientBlacklistUpdate.getClientIdBePrevent()));
        if (beBlacker == null) {
            throw new BusinessException("查无用户信息");
        }
        if (this.isBeBlack(currentClient.getClientId(), imClientBlacklistUpdate.getClientIdBePrevent())) {
            throw new BusinessException("该用户已被拉黑");
        }
        ImClientBlacklist imClientBlacklist = new ImClientBlacklist();
        imClientBlacklist.setId(SnowflakeUtil.getId());
        imClientBlacklist.setCreateTime(new Date());
        imClientBlacklist.setFkAppid(currentClient.getFkAppid());
        imClientBlacklist.setClientIdPrevent(currentClient.getClientId());
        imClientBlacklist.setClientIdBePrevent(beBlacker.getClientId());
        this.save(imClientBlacklist);

        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean removeImClientBlacklist(ImClientBlacklistUpdate imClientBlacklistUpdate) {
        // 操作者
        ImClient currentClient = contextService.getImClientIfNotNullOrThrow();
        // 被拉黑者
        ImClient beBlacker = imClientService.getOne(new QueryWrapper<ImClient>().lambda()
                .eq(ImClient::getFkAppid, currentClient.getFkAppid())
                .eq(ImClient::getClientId, imClientBlacklistUpdate.getClientIdBePrevent()));
        if (beBlacker == null) {
            throw new BusinessException("查无用户信息");
        }
        // 删除
        this.remove(new QueryWrapper<ImClientBlacklist>().lambda()
                .eq(ImClientBlacklist::getClientIdPrevent, currentClient.getClientId())
                .eq(ImClientBlacklist::getClientIdBePrevent, beBlacker.getClientId()));
        return true;
    }

    @Override
    public Paging<ImClientBlacklistQueryVo> getImClientBlacklistPageList(ImClientBlacklistPageParam imClientBlacklistPageParam) {
        ImClient currentClient = contextService.getImClientIfNotNullOrThrow();
        return getImClientBlacklistPageList(currentClient, imClientBlacklistPageParam);
    }

    @Override
    public Paging<ImClientBlacklistQueryVo> getImClientBlacklistPageListSdk(ImClientBlacklistPageParam imClientBlacklistPageParam) {
        Long appId = SecurityUtils.getCurrentAppId();
        ImClient client = imClientService.getCacheImClient(appId, imClientBlacklistPageParam.getClientId());
        if (client == null) {
            throw new BusinessException("客户端不存在");
        }
        return getImClientBlacklistPageList(client, imClientBlacklistPageParam);
    }

    private Paging<ImClientBlacklistQueryVo> getImClientBlacklistPageList(ImClient client,
                                                                          ImClientBlacklistPageParam imClientBlacklistPageParam) {

        Page<ImClientBlacklistQueryVo> page = new PageInfo<>(imClientBlacklistPageParam);
        IPage<ImClientBlacklistQueryVo> imClientBlacklistPageList = imClientBlacklistMapper.getImClientBlacklistPageList(page, client.getClientId());
        Paging<ImClientBlacklistQueryVo> imClientBlacklistQueryVoPaging = new Paging<>(imClientBlacklistPageList);
        return imClientBlacklistQueryVoPaging;
    }
}
